/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.screen;

import com.petrolpark.destroy.client.gui.DestroyGuiTextures;
import com.petrolpark.destroy.client.gui.DestroyIcons;
import com.petrolpark.destroy.client.gui.menu.RedstoneProgrammerMenu;
import com.petrolpark.destroy.network.DestroyMessages;
import com.petrolpark.destroy.network.packet.RedstoneProgramSyncC2SPacket;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RedstoneProgrammerScreen
extends AbstractSimiContainerScreen<RedstoneProgrammerMenu> {
    protected final RedstoneProgram program;
    private DestroyGuiTextures background;
    private LerpedFloat verticalScroll = LerpedFloat.linear().startWithValue(0.0);
    private LerpedFloat horizontalScroll = LerpedFloat.linear().startWithValue(0.0);
    private IconButton playPauseButton;
    private IconButton confirmButton;
    private IconButton clearButton;
    private Map<RedstoneProgram.PlayMode, IconButton> modeButtons;

    public RedstoneProgrammerScreen(RedstoneProgrammerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.program = (RedstoneProgram)container.contentHolder;
        this.background = DestroyGuiTextures.REDSTONE_PROGRAMMER;
        this.modeButtons = Map.of();
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        super.m_7856_();
        this.m_169413_();
        this.playPauseButton = new IconButton(this.f_97735_ + 10, this.f_97736_ + 20, (ScreenElement)AllIcons.I_PLAY);
        this.playPauseButton.withCallback(this.change(() -> {
            this.program.paused = !this.program.paused;
            this.program.mode = RedstoneProgram.PlayMode.MANUAL;
            this.playPauseButton.f_93623_ = !this.program.paused;
        }));
        this.m_142416_((GuiEventListener)this.playPauseButton);
        this.confirmButton = new IconButton(this.f_97735_ + this.background.width - 33, this.f_97736_ + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_6915_();
            }
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.clearButton = new IconButton(this.f_97735_ + this.background.width - 33 - 18, this.f_97736_ + this.background.height - 24, (ScreenElement)AllIcons.I_TRASH);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.modeButtons.clear();
        for (RedstoneProgram.PlayMode mode : RedstoneProgram.PlayMode.values()) {
            IconButton button = new IconButton(this.f_97735_ + 16 + mode.ordinal() * 18, this.f_97736_ + this.background.height - 24, (ScreenElement)DestroyIcons.get(mode));
            button.setToolTip(mode.description);
            button.withCallback(this.change(() -> {
                this.program.mode = mode;
            }));
            this.modeButtons.put(mode, button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.verticalScroll.tickChaser();
        this.horizontalScroll.tickChaser();
        for (Map.Entry<RedstoneProgram.PlayMode, IconButton> entry : this.modeButtons.entrySet()) {
            if (this.program.mode == entry.getKey()) {
                entry.getValue().f_93623_ = false;
                continue;
            }
            entry.getValue().f_93623_ = true;
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.background.render(graphics, this.f_97735_, this.f_97736_);
        float xOffset = this.horizontalScroll.getValue(partialTicks);
        float yOffset = -this.verticalScroll.getValue(partialTicks);
        for (RedstoneProgram.Channel channel : this.program.getChannels()) {
        }
    }

    protected Runnable change(Runnable runnable) {
        return () -> {
            runnable.run();
            DestroyMessages.sendToServer(new RedstoneProgramSyncC2SPacket(this.program));
        };
    }
}

