/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.screen;

import com.ibm.icu.text.DecimalFormat;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.VatControllerBlock;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour.VatFluidTankBehaviour;
import com.petrolpark.destroy.chemistry.ClientMixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.client.gui.DestroyGuiTextures;
import com.petrolpark.destroy.client.gui.DestroyIcons;
import com.petrolpark.destroy.client.gui.MoleculeRenderer;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.item.MoleculeDisplayItem;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.GuiHelper;
import com.petrolpark.destroy.util.vat.Vat;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class VatScreen
extends AbstractSimiScreen {
    private int ticksUntilRefresh;
    private static int CARD_HEIGHT = 32;
    private Rect2i moleculeScrollArea;
    private Rect2i textArea;
    private Rect2i filterArea;
    private static final DecimalFormat df = new DecimalFormat();
    private VatControllerBlockEntity blockEntity;
    private DestroyGuiTextures background;
    private Molecule selectedMolecule;
    private List<Pair<Molecule, Float>> orderedMolecules;
    private View selectedView;
    private LerpedFloat moleculeScroll = LerpedFloat.linear().startWithValue(0.0);
    private LerpedFloat textScroll = LerpedFloat.linear().startWithValue(0.0);
    private LerpedFloat horizontalTextScroll = LerpedFloat.linear().startWithValue(0.0);
    private float maxMoleculeScroll = 1.0f;
    private float textWidth = 0.0f;
    private float textHeight = 0.0f;
    private IconButton confirmButton;
    private IconButton controlsIcon;
    private List<IconButton> contentsShownButtons;
    private EditBox filter;

    public VatScreen(VatControllerBlockEntity vatController) {
        super((Component)DestroyLang.translate("tooltip.vat.menu.title", new Object[0]).component());
        this.background = DestroyGuiTextures.VAT;
        this.blockEntity = vatController;
        this.selectedMolecule = null;
        this.orderedMolecules = new ArrayList<Pair<Molecule, Float>>();
        this.selectedView = View.BOTH;
        this.ticksUntilRefresh = 0;
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        super.m_7856_();
        this.m_169413_();
        this.moleculeScrollArea = new Rect2i(this.guiLeft + 11, this.guiTop + 16, 119, 169);
        this.textArea = new Rect2i(this.guiLeft + 131, this.guiTop + 102, 114, 83);
        this.confirmButton = new IconButton(this.guiLeft + this.background.width - 33, this.guiTop + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_6915_();
            }
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.controlsIcon = new IconButton(this.guiLeft + 16, this.guiTop + 202, (ScreenElement)DestroyIcons.QUESTION_MARK);
        this.controlsIcon.setToolTip((Component)DestroyLang.translate("tooltip.vat.menu.controls", new Object[0]).component());
        this.m_142416_((GuiEventListener)this.controlsIcon);
        this.contentsShownButtons = new ArrayList<IconButton>(View.values().length);
        int i = 0;
        for (View view : View.values()) {
            IconButton button = new IconButton(this.guiLeft + 52 + i * 18, this.guiTop + this.background.height - 24, (ScreenElement)view.icon);
            button.withCallback(() -> {
                this.contentsShownButtons.forEach(b -> {
                    b.f_93623_ = true;
                });
                button.f_93623_ = false;
                this.selectedView = view;
                this.updateMoleculeList();
                this.moleculeScroll.updateChaseTarget(0.0f);
            });
            button.f_93623_ = this.selectedView != view;
            button.setToolTip(view.tooltip);
            this.contentsShownButtons.add(button);
            this.m_142416_((GuiEventListener)button);
            ++i;
        }
        this.filter = new EditBox(this.f_96547_, this.guiLeft + 114, this.guiTop + this.background.height - 19, 95, 10, Components.immutableEmpty());
        this.filter.m_94182_(false);
        this.filter.m_94199_(35);
        this.filter.m_93692_(false);
        this.filter.m_6375_(0.0, 0.0, 0);
        this.filter.m_94151_(s -> {
            this.updateMoleculeList();
            this.moleculeScroll.updateChaseTarget(0.0f);
        });
        this.filter.f_93623_ = false;
        this.filter.m_257544_(Tooltip.m_257550_((Component)DestroyLang.translate("tooltip.vat.menu.search_filter", new Object[0]).component()));
        this.m_142416_((GuiEventListener)this.filter);
        this.filterArea = new Rect2i(this.guiLeft + 110, this.guiTop + this.background.height - 24, this.guiLeft + 114 + 95, this.guiTop + this.background.height - 24 + 18);
        this.updateMoleculeList();
    }

    public void m_86600_() {
        super.m_86600_();
        this.moleculeScroll.tickChaser();
        this.textScroll.tickChaser();
        this.horizontalTextScroll.tickChaser();
        if (this.m_7222_() != this.filter) {
            this.filter.m_94196_(this.filter.m_94155_().length());
            this.filter.m_94208_(this.filter.m_94207_());
        }
        --this.ticksUntilRefresh;
        if (this.ticksUntilRefresh < 0) {
            this.ticksUntilRefresh = 20;
            this.updateMoleculeList();
        }
    }

    protected void updateMoleculeList() {
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        int amount = 0;
        VatFluidTankBehaviour.VatTankSegment.VatFluidTank tank = null;
        switch (this.selectedView) {
            case BOTH: {
                mixture = this.blockEntity.getCombinedReadOnlyMixture();
                amount = this.blockEntity.getVatOptional().map(Vat::getCapacity).orElse(0);
                break;
            }
            case GAS: {
                tank = this.blockEntity.getGasTank();
            }
            case LIQUID: {
                if (this.selectedView == View.LIQUID) {
                    tank = this.blockEntity.getLiquidTank();
                }
            }
            default: {
                if (tank == null) break;
                amount = tank.getFluidAmount();
                FluidStack stack = tank.getFluid();
                if (!DestroyFluids.isMixture(stack)) break;
                mixture = ReadOnlyMixture.readNBT(ClientMixture::new, stack.getOrCreateChildTag("Mixture"));
            }
        }
        this.orderedMolecules = new ArrayList<Pair<Molecule, Float>>(mixture.getContents(false).size());
        for (Molecule molecule : mixture.getContents(false)) {
            String search = this.filter.m_94155_().toUpperCase();
            if (this.filter != null && !this.filter.m_94155_().isEmpty() && molecule.getName(false).getString().toUpperCase().indexOf(search) <= -1 && molecule.getName(true).getString().toUpperCase().indexOf(search) <= -1 && molecule.getSerlializedMolecularFormula(false).toUpperCase().indexOf(search) <= -1) continue;
            this.orderedMolecules.add((Pair<Molecule, Float>)Pair.of((Object)molecule, (Object)Float.valueOf(mixture.getConcentrationOf(molecule) * (float)amount / 1000.0f)));
        }
        Collections.sort(this.orderedMolecules, (p1, p2) -> Float.compare(((Float)p2.getSecond()).floatValue(), ((Float)p1.getSecond()).floatValue()));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.moleculeScrollArea.m_110087_((int)mouseX, (int)mouseY)) {
            float chaseTarget = this.moleculeScroll.getChaseTarget();
            float max = -132.0f;
            if ((max += (float)((this.orderedMolecules.size() - 1) * CARD_HEIGHT)) >= 0.0f) {
                chaseTarget = (float)((double)chaseTarget - delta * 12.0);
                chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
                this.moleculeScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
            } else {
                this.moleculeScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
            this.maxMoleculeScroll = max;
            return true;
        }
        if (this.textArea.m_110087_((int)mouseX, (int)mouseY)) {
            if (VatScreen.m_96638_()) {
                float chaseTarget = this.horizontalTextScroll.getChaseTarget();
                float max = this.textWidth - 106.0f;
                if (max >= 0.0f) {
                    chaseTarget = (float)((double)chaseTarget - delta * 6.0);
                    chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
                    this.horizontalTextScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
                } else {
                    this.horizontalTextScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
                }
            } else {
                float chaseTarget = this.textScroll.getChaseTarget();
                float max = this.textHeight - 76.0f;
                if (max >= 0.0f) {
                    chaseTarget = (float)((double)chaseTarget - delta * 6.0);
                    chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
                    this.textScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
                } else {
                    this.textScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
                }
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.filterArea.m_110087_((int)mouseX, (int)mouseY) && !this.filter.m_93696_()) {
            this.filter.m_93692_(true);
            this.filter.m_94208_(0);
            this.m_7522_((GuiEventListener)this.filter);
            return true;
        }
        this.filter.m_93692_(false);
        if (this.moleculeScrollArea.m_110087_((int)mouseX, (int)mouseY)) {
            for (int i = 0; i < this.orderedMolecules.size(); ++i) {
                int yPos = this.guiTop + (i + 1) * CARD_HEIGHT - (int)this.moleculeScroll.getChaseTarget() - 14;
                Rect2i clickArea = new Rect2i(this.moleculeScrollArea.m_110085_() + 15, yPos, 97, 28);
                if (!clickArea.m_110087_((int)mouseX, (int)mouseY)) continue;
                Molecule molecule = (Molecule)this.orderedMolecules.get(i).getFirst();
                this.selectedMolecule = this.selectedMolecule != null && this.selectedMolecule.getFullID().equals(molecule.getFullID()) ? null : molecule;
                this.textScroll.chase(0.0, 0.7, LerpedFloat.Chaser.EXP);
                this.horizontalTextScroll.chase(0.0, 0.7, LerpedFloat.Chaser.EXP);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() instanceof EditBox && (keyCode == 257 || keyCode == 335) && this.filter.m_93696_()) {
            this.filter.m_93692_(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        PoseStack ms = graphics.m_280168_();
        boolean iupac = (Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get();
        float scrollOffset = -this.moleculeScroll.getValue(partialTicks);
        this.background.render(graphics, this.guiLeft, this.guiTop);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.guiLeft + 21, this.guiTop + 4, 5513551, false);
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        GuiHelper.startStencil(graphics, this.moleculeScrollArea.m_110085_(), this.moleculeScrollArea.m_110086_(), this.moleculeScrollArea.m_110090_(), this.moleculeScrollArea.m_110091_());
        ms.m_85836_();
        ms.m_252880_((float)(this.guiLeft + 25), (float)(this.guiTop + 20) + scrollOffset, 0.0f);
        for (Pair<Molecule, Float> pair : this.orderedMolecules) {
            ms.m_85836_();
            Molecule molecule = (Molecule)pair.getFirst();
            boolean selected = this.selectedMolecule != null && molecule.getFullID().equals(this.selectedMolecule.getFullID());
            (selected ? DestroyGuiTextures.VAT_CARD_SELECTED : DestroyGuiTextures.VAT_CARD_UNSELECTED).render(graphics, selected ? -1 : 0, selected ? -1 : 0);
            graphics.m_280488_(this.f_96547_, DestroyLang.shorten(molecule.getName(iupac).getString(), this.f_96547_, 92), 4, 4, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)DestroyLang.translate("tooltip.vat.menu.moles", df.format(pair.getSecond())).component(), 4, 17, 0xFFFFFF);
            ms.m_85849_();
            ms.m_252880_(0.0f, (float)CARD_HEIGHT, 0.0f);
        }
        ms.m_85849_();
        GuiHelper.endStencil();
        DestroyGuiTextures.VAT_SCROLL_DOT.render(graphics, this.guiLeft + 15, this.guiTop + 20 + (int)(this.moleculeScroll.getValue(partialTicks) * 154.0f / this.maxMoleculeScroll));
        graphics.m_280120_(this.moleculeScrollArea.m_110085_(), this.moleculeScrollArea.m_110086_(), this.moleculeScrollArea.m_110085_() + this.moleculeScrollArea.m_110090_(), this.moleculeScrollArea.m_110086_() + 10, 200, 0x77000000, 0);
        graphics.m_280120_(this.moleculeScrollArea.m_110085_(), this.moleculeScrollArea.m_110086_() + this.moleculeScrollArea.m_110091_() - 10, this.moleculeScrollArea.m_110085_() + this.moleculeScrollArea.m_110090_(), this.moleculeScrollArea.m_110086_() + this.moleculeScrollArea.m_110091_(), 200, 0, 0x77000000);
        if (this.selectedMolecule != null) {
            ms.m_85836_();
            ms.m_252880_((float)(this.guiLeft + 131), (float)(this.guiTop + 16), 100.0f);
            GuiHelper.startStencil(graphics, 0.0f, 0.0f, 114.0f, 85.0f);
            MoleculeRenderer renderer = this.selectedMolecule.getRenderer();
            ms.m_85837_((double)(-renderer.getWidth()) / 2.0, (double)(-renderer.getHeight()) / 2.0, 0.0);
            renderer.render(56, 42, graphics);
            GuiHelper.endStencil();
            ms.m_85849_();
        }
        Objects.requireNonNull(this.f_96547_);
        this.textHeight = 9.0f;
        this.textWidth = 0.0f;
        GuiHelper.startStencil(graphics, this.textArea.m_110085_(), this.textArea.m_110086_(), this.textArea.m_110090_(), this.textArea.m_110091_());
        ms.m_85836_();
        ms.m_252880_((float)(this.guiLeft + 135 - (int)this.horizontalTextScroll.getValue(partialTicks)), (float)(this.guiTop + 106 - (int)this.textScroll.getValue(partialTicks)), 0.0f);
        if (this.selectedMolecule != null) {
            graphics.m_280430_(this.f_96547_, this.selectedMolecule.getName(iupac), 0, 0, 0xFFFFFF);
            this.textWidth = this.f_96547_.m_92852_((FormattedText)this.selectedMolecule.getName(iupac));
            for (Component line : MoleculeDisplayItem.getLore(this.selectedMolecule)) {
                Objects.requireNonNull(this.f_96547_);
                this.textHeight += 9.0f;
                this.textWidth = Math.max(this.textWidth, (float)this.f_96547_.m_92852_((FormattedText)line));
                Objects.requireNonNull(this.f_96547_);
                ms.m_252880_(0.0f, 9.0f, 0.0f);
                graphics.m_280430_(this.f_96547_, line, 0, 0, 0xFFFFFF);
            }
        } else {
            graphics.m_280430_(this.f_96547_, (Component)DestroyLang.translate(this.orderedMolecules.isEmpty() ? "tooltip.vat.menu.empty" : "tooltip.vat.menu.select", new Object[0]).component(), 0, 0, 0xFFFFFF);
        }
        ms.m_85849_();
        GuiHelper.endStencil();
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
        graphics.m_280614_(this.f_96547_, (Component)DestroyLang.translate("tooltip.vat.menu.filters", new Object[0]).component(), this.guiLeft + 52, this.guiTop + this.background.height - 34, 5726074, false);
        if (!this.blockEntity.m_58898_()) {
            return;
        }
        ms.m_85836_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)msr.pushPose()).translate((double)(this.guiLeft + this.background.width + 4), (double)(this.guiTop + this.background.height + 4), 100.0)).scale(40.0f)).rotateX(-22.0)).rotateY(63.0);
        GuiGameElement.of((BlockState)((BlockState)DestroyBlocks.VAT_CONTROLLER.getDefaultState().m_61124_((Property)VatControllerBlock.f_54117_, (Comparable)Direction.WEST))).render(graphics);
        ms.m_85849_();
    }

    static {
        df.setMinimumFractionDigits(5);
        df.setMaximumFractionDigits(5);
    }

    protected static enum View {
        BOTH(DestroyIcons.VAT_ALL, (Component)DestroyLang.translate("tooltip.vat.menu.view.both", new Object[0]).component()),
        LIQUID(DestroyIcons.VAT_SOLUTION, (Component)DestroyLang.translate("tooltip.vat.menu.view.liquid", new Object[0]).component()),
        GAS(DestroyIcons.VAT_GAS, (Component)DestroyLang.translate("tooltip.vat.menu.view.gas", new Object[0]).component());

        public final DestroyIcons icon;
        public final Component tooltip;

        private View(DestroyIcons icon, Component tooltip) {
            this.icon = icon;
            this.tooltip = tooltip;
        }
    }
}

