/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.stackedtextbox;

import com.petrolpark.destroy.client.gui.stackedtextbox.StackedTextBoxComponent;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public abstract class AbstractStackedTextBox
extends ElementWidget {
    protected Minecraft minecraft;
    protected AbstractStackedTextBox parent;
    protected AbstractStackedTextBox child;
    public static AbstractStackedTextBox NOTHING = new AbstractStackedTextBox(0, 0, null, null){

        @Override
        public void close() {
        }

        public boolean m_142518_() {
            return false;
        }
    };

    protected AbstractStackedTextBox(int x, int y, AbstractStackedTextBox parent, AbstractStackedTextBox child) {
        super(x, y);
        this.parent = parent;
        this.child = child;
    }

    public abstract void close();

    public static LinesAndActivationAreas getTextAndActivationAreas(String text, int startX, int startY, int maxWidthPerLine, Screen screen, Font font, TooltipHelper.Palette palette, boolean isTextBox) {
        if (screen == null) {
            return new LinesAndActivationAreas(List.of(), List.of(), startX, startY, 0, 0);
        }
        List<Object> components = new ArrayList<StackedTextBoxComponent>();
        Object currentSection = "";
        boolean inMoleculeName = false;
        boolean inDefinition = false;
        boolean failed = false;
        block6: for (char character : text.toCharArray()) {
            switch (character) {
                case '[': {
                    if (inDefinition) {
                        failed = true;
                        break block6;
                    }
                    inMoleculeName = true;
                    components.add(new StackedTextBoxComponent.Plain(String.valueOf(currentSection)));
                    currentSection = "";
                    continue block6;
                }
                case ']': {
                    if (!inMoleculeName) {
                        failed = true;
                        break block6;
                    }
                    inMoleculeName = false;
                    components.add(new StackedTextBoxComponent.Molecule(String.valueOf(currentSection)));
                    currentSection = "";
                    continue block6;
                }
                case '{': {
                    if (inMoleculeName) {
                        failed = true;
                        break block6;
                    }
                    inDefinition = true;
                    components.add(new StackedTextBoxComponent.Plain(String.valueOf(currentSection)));
                    currentSection = "";
                    continue block6;
                }
                case '}': {
                    if (!inDefinition) {
                        failed = true;
                        break block6;
                    }
                    inDefinition = false;
                    components.add(new StackedTextBoxComponent.Definition(String.valueOf(currentSection)));
                    currentSection = "";
                    continue block6;
                }
                default: {
                    currentSection = (String)currentSection + character;
                }
            }
        }
        if (currentSection != "") {
            components.add(new StackedTextBoxComponent.Plain(String.valueOf(currentSection)));
        }
        if (failed) {
            components = List.of(new StackedTextBoxComponent.Plain("Badly formatted definition: " + text));
        }
        ArrayList<Pair<Area, String>> areasAndTextBoxes = new ArrayList<Pair<Area, String>>();
        Area currentActivationArea = new Area(0, 0, 0, 0);
        int maxLineWidth = 0;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int currentLineWidth = 0;
        for (StackedTextBoxComponent stackedTextBoxComponent : components) {
            for (String word : stackedTextBoxComponent.getWords()) {
                int wordWidth = font.m_92895_(word.replaceAll("_", ""));
                if (currentLineWidth + wordWidth > maxWidthPerLine) {
                    if (currentLineWidth > 0) {
                        String string = currentLine.toString();
                        lines.add(string);
                        currentLine = new StringBuilder();
                        currentLineWidth = 0;
                    } else {
                        lines.add(word);
                        maxLineWidth = Math.max(maxLineWidth, wordWidth);
                        currentActivationArea.minX = startX;
                        currentActivationArea.maxX = startX + wordWidth;
                        continue;
                    }
                }
                currentLine.append(word);
                currentActivationArea.minX = startX + currentLineWidth;
                int n = startY + (isTextBox ? -3 : 0);
                int n2 = lines.size();
                Objects.requireNonNull(font);
                currentActivationArea.minY = n + n2 * 9;
                int n3 = startY + (isTextBox ? -3 : 0);
                int n4 = lines.size() + 1;
                Objects.requireNonNull(font);
                currentActivationArea.maxY = n3 + n4 * 9;
                maxLineWidth = Math.max(maxLineWidth, currentLineWidth += wordWidth);
                currentActivationArea.maxX = startX + currentLineWidth;
            }
            if (stackedTextBoxComponent instanceof StackedTextBoxComponent.Definition) {
                StackedTextBoxComponent.Definition definition = (StackedTextBoxComponent.Definition)stackedTextBoxComponent;
                areasAndTextBoxes.add(Pair.of((Object)currentActivationArea, (Object)Component.m_237115_((String)definition.definitionTranslationKey).getString()));
            }
            currentActivationArea = new Area(0, 0, 0, 0);
        }
        if (currentLineWidth > 0) {
            lines.add(currentLine.toString());
        }
        Couple styles = Couple.create((Object)palette.highlight(), (Object)palette.primary());
        MutableComponent mutableComponent = Component.m_237113_((String)"");
        mutableComponent.m_130948_(palette.primary());
        boolean currentlyHighlighted = false;
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        for (String line : lines) {
            String[] stringArray;
            MutableComponent currentComponent = mutableComponent.m_6879_();
            for (String part : stringArray = line.split("_")) {
                currentComponent.m_7220_((Component)Components.literal((String)part).m_130948_((Style)styles.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        int width = maxLineWidth + 5;
        int n = lines.size() + 1;
        Objects.requireNonNull(font);
        int height = 11 + n * 9;
        if (startX + width / 2 > screen.f_96543_ / 2) {
            startX -= width;
            for (Pair pair : areasAndTextBoxes) {
                ((Area)pair.getFirst()).minX -= width;
                ((Area)pair.getFirst()).maxX -= width;
            }
        }
        if (startY + height / 2 > screen.f_96544_ / 2) {
            Objects.requireNonNull(font);
            startY -= height + 9;
            for (Pair pair : areasAndTextBoxes) {
                int n5 = ((Area)pair.getFirst()).minY;
                Objects.requireNonNull(font);
                ((Area)pair.getFirst()).minY = n5 - (height + 9);
                int n6 = ((Area)pair.getFirst()).maxY;
                Objects.requireNonNull(font);
                ((Area)pair.getFirst()).maxY = n6 - (height + 9);
            }
        }
        return new LinesAndActivationAreas(formattedLines, areasAndTextBoxes, startX, startY, width, height);
    }

    public record LinesAndActivationAreas(List<Component> lines, List<Pair<Area, String>> areas, int startX, int startY, int width, int height) {
    }

    public static class Area {
        int minX;
        int maxX;
        int minY;
        int maxY;

        public Area(int x, int y, int width, int height) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + height;
        }

        public boolean isIn(int x, int y) {
            return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
        }
    }
}

