/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.stackedtextbox;

import com.google.common.base.Strings;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.client.gui.stackedtextbox.AbstractStackedTextBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StackedTextBox
extends AbstractStackedTextBox {
    private static final int PERMANENCE_LIFETIME = 15;
    private TooltipHelper.Palette palette;
    private String plainText = "";
    private AbstractStackedTextBox.Area activationArea;
    private boolean isActivationAreaHovered;
    private List<Pair<AbstractStackedTextBox.Area, String>> possibleChildActivationAreas;
    private int lifetime;
    private final List<Component> lines;

    public StackedTextBox(Minecraft minecraft, int x, int y, AbstractStackedTextBox parent) {
        super(x, y, parent, AbstractStackedTextBox.NOTHING);
        this.minecraft = minecraft;
        this.palette = TooltipHelper.Palette.GRAY_AND_WHITE;
        this.activationArea = new AbstractStackedTextBox.Area(x, y, this.f_93618_, this.f_93619_);
        this.isActivationAreaHovered = true;
        this.possibleChildActivationAreas = List.of();
        this.lifetime = 0;
        this.lines = new ArrayList<Component>();
    }

    public StackedTextBox withPalette(TooltipHelper.Palette palette) {
        this.palette = palette;
        return this;
    }

    public StackedTextBox withActivationArea(AbstractStackedTextBox.Area area) {
        this.activationArea = area;
        return this;
    }

    public StackedTextBox withText(String text) {
        this.plainText = text;
        this.updateTextBoxSize(text);
        return this;
    }

    protected void updateTextBoxSize(String text) {
        AbstractStackedTextBox.LinesAndActivationAreas result = StackedTextBox.getTextAndActivationAreas(text, this.m_252754_(), this.m_252907_(), 200, this.minecraft.f_91080_, this.minecraft.f_91062_, this.palette, true);
        this.lines.clear();
        this.lines.addAll(result.lines());
        this.possibleChildActivationAreas = result.areas();
        this.f_93618_ = result.width();
        this.f_93619_ = result.height();
        this.m_252865_(result.startX());
        this.m_253211_(result.startY());
    }

    protected void beforeRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(guiGraphics, mouseX, mouseY, partialTicks);
        this.isActivationAreaHovered = this.activationArea.isIn(mouseX, mouseY);
        if (this.child == AbstractStackedTextBox.NOTHING && this.lifetime >= 15) {
            for (Pair<AbstractStackedTextBox.Area, String> pair : this.possibleChildActivationAreas) {
                AbstractStackedTextBox.Area area = (AbstractStackedTextBox.Area)pair.getFirst();
                if (!area.isIn(mouseX, mouseY)) continue;
                this.child = new StackedTextBox(this.minecraft, mouseX, mouseY, (AbstractStackedTextBox)this).withActivationArea(area).withPalette(this.palette).withText(Component.m_237115_((String)((String)pair.getSecond())).getString());
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.m_142518_()) {
            return;
        }
        PoseStack ms = guiGraphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 300.0f);
        Screen screen = this.minecraft.f_91080_;
        if (screen != null) {
            if (this.m_252754_() + this.f_93618_ > screen.f_96543_ || this.m_252907_() + this.f_93619_ > screen.f_96544_) {
                this.updateTextBoxSize(this.plainText);
                return;
            }
            ms.m_252880_(0.0f, 0.0f, 10.0f);
            ArrayList<Component> allLines = new ArrayList<Component>(this.lines);
            allLines.add(this.progressBar());
            RemovedGuiUtils.drawHoveringText((GuiGraphics)guiGraphics, allLines, (int)(this.m_252754_() - 22), (int)(this.m_252907_() + 5), (int)screen.f_96543_, (int)screen.f_96544_, (int)-1, (Font)this.minecraft.f_91062_);
        }
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 1.0f);
        this.child.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        ms.m_85849_();
        ms.m_85849_();
    }

    public void tick() {
        super.tick();
        if (this.lifetime < 15) {
            ++this.lifetime;
        }
        if (!this.m_142518_()) {
            this.close();
        }
        this.child.tick();
    }

    public boolean m_142518_() {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        if (this.child.m_142518_()) {
            return true;
        }
        if (this.lifetime < 15) {
            return this.isActivationAreaHovered;
        }
        return this.f_93622_ || this.isActivationAreaHovered;
    }

    @Override
    public void close() {
        this.lifetime = 0;
        this.child.close();
        if (this.parent != AbstractStackedTextBox.NOTHING) {
            this.parent.child = AbstractStackedTextBox.NOTHING;
        }
    }

    private Component progressBar() {
        float charWidth = this.minecraft.f_91062_.m_92895_("|");
        int total = (int)((float)(this.f_93618_ - 5) / charWidth);
        int current = (int)((float)this.lifetime * (float)total / 15.0f);
        Object bars = "";
        bars = (String)bars + ChatFormatting.GRAY + Strings.repeat((String)"|", (int)current);
        bars = (String)bars + ChatFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(total - current));
        return Components.literal((String)bars);
    }
}

