/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.gui.stackedtextbox;

import com.petrolpark.destroy.config.DestroyAllConfigs;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public abstract class StackedTextBoxComponent {
    public final String value;

    public StackedTextBoxComponent(String value) {
        this.value = value;
    }

    public abstract String[] getWords();

    public static class Definition
    extends StackedTextBoxComponent {
        private String displayedString;
        public final String definitionTranslationKey;

        public Definition(String value) {
            super(value);
            String[] s = value.split(",");
            if (s.length != 2) {
                this.displayedString = Component.m_237115_((String)"destroy.chemistry.unknown_definition").getString();
                this.definitionTranslationKey = "destroy.chemistry.unknown_definition";
            } else {
                this.displayedString = "_" + s[0] + "_";
                String[] definitionId = s[1].trim().split(":");
                this.definitionTranslationKey = definitionId[0] + ".chemistry." + definitionId[1];
            }
        }

        @Override
        public String[] getWords() {
            return new String[]{this.displayedString};
        }
    }

    public static class Molecule
    extends Plain {
        public Molecule(String value) {
            super(value);
            String[] nameSpaceAndId = value.split(":");
            String key = nameSpaceAndId[0] + ".chemical." + nameSpaceAndId[1];
            String iupacKey = key + ".iupac";
            if (((Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get()).booleanValue() && I18n.m_118936_((String)iupacKey)) {
                key = iupacKey;
            }
            String moleculeName = Component.m_237115_((String)key).getString();
            this.setWords(moleculeName);
        }
    }

    public static class Plain
    extends StackedTextBoxComponent {
        private List<String> words;

        public Plain(String value) {
            super(value);
            this.setWords(value);
        }

        protected void setWords(String value) {
            this.words = new LinkedList<String>();
            BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
            iterator.setText(value);
            int start = iterator.first();
            int end = iterator.next();
            while (end != -1) {
                String word = value.substring(start, end);
                this.words.add(word);
                start = end;
                end = iterator.next();
            }
        }

        @Override
        public String[] getWords() {
            return this.words.toArray(new String[this.words.size()]);
        }
    }
}

