/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.particle;

import com.petrolpark.destroy.client.particle.TearParticle;
import com.petrolpark.destroy.client.particle.TintedSplashParticle;
import com.petrolpark.destroy.client.particle.data.GasParticleData;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public enum DestroyParticleTypes {
    DISTILLATION(GasParticleData::new),
    EVAPORATION(GasParticleData::new),
    TEAR(TearParticle.Data::new),
    TINTED_SPLASH(TintedSplashParticle.Data::new);

    private final ParticleEntry<?> particleEntry;

    private <T extends ParticleOptions> DestroyParticleTypes(Supplier<? extends ICustomParticleData<T>> typeProvider) {
        this.particleEntry = new ParticleEntry(Lang.asId((String)this.name()), typeProvider);
    }

    public static void register(IEventBus eventBus) {
        ParticleEntry.PARTICLE_TYPES.register(eventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerProviders(RegisterParticleProvidersEvent event) {
        for (DestroyParticleTypes particleType : DestroyParticleTypes.values()) {
            particleType.particleEntry.registerProvider(event);
        }
    }

    public ParticleType<?> get() {
        return (ParticleType)this.particleEntry.object.get();
    }

    private static class ParticleEntry<T extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"destroy");
        private final String name;
        private final Supplier<? extends ICustomParticleData<T>> typeProvider;
        private final RegistryObject<ParticleType<T>> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<T>> typeProvider) {
            this.name = name;
            this.typeProvider = typeProvider;
            this.object = PARTICLE_TYPES.register(this.name, () -> ((ICustomParticleData)typeProvider.get()).createType());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerProvider(RegisterParticleProvidersEvent event) {
            this.typeProvider.get().register((ParticleType)this.object.get(), event);
        }
    }
}

