/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.particle;

import com.petrolpark.destroy.block.entity.BubbleCapBlockEntity;
import com.petrolpark.destroy.client.particle.DestroyParticleTypes;
import com.petrolpark.destroy.client.particle.data.GasParticleData;
import com.simibubi.create.content.fluids.particle.FluidStackParticle;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;

public class GasParticle
extends FluidStackParticle {
    private static final int TICKS_PER_BLOCK = BubbleCapBlockEntity.getTankCapacity() / BubbleCapBlockEntity.getTransferRate();
    private static final float VERTICAL_SPEED = 1.0f / (float)TICKS_PER_BLOCK;
    private final boolean isDistillation;
    private final float blockHeight;

    private GasParticle(ClientLevel level, FluidStack fluid, ParticleType<GasParticleData> type, float blockHeight, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(level, fluid, x, y, z, vx, vy, vz);
        this.m_108335_(sprites);
        this.f_107226_ = 0.0f;
        this.f_107663_ *= 6.0f;
        this.blockHeight = blockHeight;
        if (type == DestroyParticleTypes.DISTILLATION.get() && blockHeight != 0.0f) {
            this.isDistillation = true;
            this.f_107225_ = (int)(this.blockHeight * (float)TICKS_PER_BLOCK);
            this.f_107216_ += (double)VERTICAL_SPEED + (double)(this.f_107223_.m_188501_() / 500.0f);
        } else {
            this.isDistillation = false;
            this.f_107225_ = (int)Mth.m_14179_((float)(fluid.getAmount() / 4000), (float)60.0f, (float)300.0f);
        }
        this.f_107219_ = !this.isDistillation;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ += (double)(this.f_107223_.m_188501_() / 5000.0f * (float)(this.f_107223_.m_188499_() ? 1 : -1));
        this.f_107217_ += (double)(this.f_107223_.m_188501_() / 5000.0f * (float)(this.f_107223_.m_188499_() ? 1 : -1));
        if (this.isDistillation) {
            this.m_6257_(0.0, VERTICAL_SPEED, 0.0);
        }
        if (this.f_107225_ - this.f_107224_ < TICKS_PER_BLOCK && this.f_107230_ > 0.01f) {
            this.f_107230_ -= 0.015f;
        }
    }

    protected float m_5970_() {
        return this.f_108321_.m_118409_();
    }

    protected float m_5952_() {
        return this.f_108321_.m_118410_();
    }

    protected float m_5951_() {
        return this.f_108321_.m_118411_();
    }

    protected float m_5950_() {
        return this.f_108321_.m_118412_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected boolean canEvaporate() {
        return false;
    }

    public static class Provider
    implements ParticleProvider<GasParticleData> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(GasParticleData data, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new GasParticle(level, data.getFluid(), data.m_6012_(), data.getBlockHeight(), x, y, z, vx, vy, vz, this.spriteSet);
        }
    }
}

