/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.client.particle.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.destroy.client.particle.DestroyParticleTypes;
import com.petrolpark.destroy.client.particle.GasParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class GasParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<GasParticleData> {
    private ParticleType<GasParticleData> type;
    private FluidStack fluid;
    private float blockHeight;
    public static final Codec<GasParticleData> DISTILLATION_CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid), (App)Codec.FLOAT.fieldOf("blockHeight").forGetter(p -> Float.valueOf(p.blockHeight))).apply((Applicative)i, (fluidStack, blockHeight) -> new GasParticleData(DestroyParticleTypes.DISTILLATION.get(), (FluidStack)fluidStack, blockHeight.floatValue())));
    public static final Codec<GasParticleData> EVAPORATION_CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fluidStack -> new GasParticleData(DestroyParticleTypes.EVAPORATION.get(), (FluidStack)fluidStack, 0.0f)));
    public static final ParticleOptions.Deserializer<GasParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GasParticleData>(){

        public GasParticleData fromCommand(ParticleType<GasParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new GasParticleData(particleTypeIn, new FluidStack((Fluid)Fluids.f_76193_, 1), 5.0f);
        }

        public GasParticleData fromNetwork(ParticleType<GasParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new GasParticleData(particleTypeIn, buffer.readFluidStack(), buffer.readInt());
        }
    };

    public GasParticleData() {
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public float getBlockHeight() {
        return this.blockHeight;
    }

    public GasParticleData(ParticleType<?> type, FluidStack fluid) {
        this(type, fluid, 0.0f);
    }

    public GasParticleData(ParticleType<?> type, FluidStack fluid, float blockHeight) {
        this.type = type;
        this.fluid = fluid;
        this.blockHeight = blockHeight;
    }

    public Codec<GasParticleData> getCodec(ParticleType<GasParticleData> type) {
        if (type == DestroyParticleTypes.DISTILLATION.get()) {
            return DISTILLATION_CODEC;
        }
        return EVAPORATION_CODEC;
    }

    public ParticleOptions.Deserializer<GasParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public ParticleType<GasParticleData> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.fluid);
        buffer.writeFloat(this.blockHeight);
    }

    public String m_5942_() {
        return RegisteredObjects.getKeyOrThrow(this.type) + " " + RegisteredObjects.getKeyOrThrow((Fluid)this.fluid.getFluid());
    }

    public ParticleEngine.SpriteParticleRegistration<GasParticleData> getMetaFactory() {
        return GasParticle.Provider::new;
    }
}

