/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.compat.jei.DestroyRecipeManagerPlugin;
import com.petrolpark.destroy.compat.jei.MixtureFluidSubtypeInterpreter;
import com.petrolpark.destroy.compat.jei.MoleculeJEIIngredient;
import com.petrolpark.destroy.compat.jei.category.AgingCategory;
import com.petrolpark.destroy.compat.jei.category.CentrifugationCategory;
import com.petrolpark.destroy.compat.jei.category.ChargingCategory;
import com.petrolpark.destroy.compat.jei.category.DestroyRecipeCategory;
import com.petrolpark.destroy.compat.jei.category.DistillationCategory;
import com.petrolpark.destroy.compat.jei.category.ElectrolysisCategory;
import com.petrolpark.destroy.compat.jei.category.ExtrusionCategory;
import com.petrolpark.destroy.compat.jei.category.GenericReactionCategory;
import com.petrolpark.destroy.compat.jei.category.ITickableCategory;
import com.petrolpark.destroy.compat.jei.category.MutationCategory;
import com.petrolpark.destroy.compat.jei.category.ObliterationCategory;
import com.petrolpark.destroy.compat.jei.category.ReactionCategory;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.recipe.AgingRecipe;
import com.petrolpark.destroy.recipe.CentrifugationRecipe;
import com.petrolpark.destroy.recipe.ChargingRecipe;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.recipe.DistillationRecipe;
import com.petrolpark.destroy.recipe.ElectrolysisRecipe;
import com.petrolpark.destroy.recipe.ExtendedDurationFireworkRocketRecipe;
import com.petrolpark.destroy.recipe.ExtrusionRecipe;
import com.petrolpark.destroy.recipe.MutationRecipe;
import com.petrolpark.destroy.recipe.ObliterationRecipe;
import com.petrolpark.destroy.recipe.ReactionRecipe;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@JeiPlugin
public class DestroyJEI
implements IModPlugin {
    public static Optional<IJeiRuntime> jeiRuntime = Optional.empty();
    public static final Map<RecipeType<?>, Class<? extends Recipe<?>>> RECIPE_TYPES = new HashMap();
    public static final Map<Molecule, List<Recipe<?>>> MOLECULES_INPUT = new HashMap();
    public static final Map<Molecule, List<Recipe<?>>> MOLECULES_OUTPUT = new HashMap();
    public static boolean MOLECULE_RECIPES_NEED_PROCESSING = true;
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private static final List<ITickableCategory> tickingCategories = new ArrayList<ITickableCategory>();

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<AgingRecipe> aging = this.builder(AgingRecipe.class).addTypedRecipes(DestroyRecipeTypes.AGING).acceptsMixtures().catalyst(() -> DestroyBlocks.AGING_BARREL.get()).itemIcon((ItemLike)DestroyBlocks.AGING_BARREL.get()).emptyBackground(177, 86).build("aging", AgingCategory::new);
        CreateRecipeCategory<CentrifugationRecipe> centrifugation = this.builder(CentrifugationRecipe.class).addTypedRecipes(DestroyRecipeTypes.CENTRIFUGATION).acceptsMixtures().catalyst(() -> DestroyBlocks.CENTRIFUGE.get()).itemIcon((ItemLike)DestroyBlocks.CENTRIFUGE.get()).emptyBackground(120, 115).build("centrifugation", CentrifugationCategory::new);
        CreateRecipeCategory<ChargingRecipe> charging = this.builder(ChargingRecipe.class).addTypedRecipes(DestroyRecipeTypes.CHARGING).catalyst(() -> DestroyBlocks.DYNAMO.get()).itemIcon((ItemLike)DestroyBlocks.DYNAMO).emptyBackground(177, 70).build("charging", ChargingCategory::new);
        CreateRecipeCategory<DistillationRecipe> distillation = this.builder(DistillationRecipe.class).addTypedRecipes(DestroyRecipeTypes.DISTILLATION).acceptsMixtures().catalyst(() -> DestroyBlocks.BUBBLE_CAP.get()).itemIcon((ItemLike)DestroyBlocks.BUBBLE_CAP.get()).emptyBackground(123, 125).build("distillation", DistillationCategory::new);
        CreateRecipeCategory extrusion = this.builder(ExtrusionRecipe.class).addRecipes(() -> ExtrusionRecipe.RECIPES).catalyst(() -> DestroyBlocks.EXTRUSION_DIE.get()).itemIcon((ItemLike)DestroyBlocks.EXTRUSION_DIE.get()).emptyBackground(177, 55).build("extrusion", ExtrusionCategory::new);
        CreateRecipeCategory mutation = this.builder(MutationRecipe.class).addRecipes(() -> MutationCategory.RECIPES).catalyst(() -> DestroyItems.HYPERACCUMULATING_FERTILIZER.get()).itemIcon((ItemLike)DestroyItems.HYPERACCUMULATING_FERTILIZER.get()).emptyBackground(120, 125).build("mutation", MutationCategory::new);
        CreateRecipeCategory<ObliterationRecipe> obliteration = this.builder(ObliterationRecipe.class).addTypedRecipes(DestroyRecipeTypes.OBLITERATION).itemIcon((ItemLike)DestroyBlocks.NITROCELLULOSE_BLOCK.get()).emptyBackground(177, 70).build("obliteration", ObliterationCategory::new);
        CreateRecipeCategory reaction = this.builder(ReactionRecipe.class).addRecipes(ReactionCategory.RECIPES::values).catalyst(() -> ((BlockEntry)AllBlocks.MECHANICAL_MIXER).get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).catalyst(() -> DestroyBlocks.VAT_CONTROLLER.get()).itemIcon((ItemLike)DestroyItems.MOLECULE_DISPLAY.get()).emptyBackground(180, 125).build("reaction", ReactionCategory::new);
        CreateRecipeCategory genericReaction = this.builder(ReactionRecipe.GenericReactionRecipe.class).addRecipes(GenericReactionCategory.RECIPES::values).catalyst(() -> ((BlockEntry)AllBlocks.MECHANICAL_MIXER).get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).catalyst(() -> DestroyBlocks.VAT_CONTROLLER.get()).itemIcon((ItemLike)DestroyItems.MOLECULE_DISPLAY.get()).emptyBackground(180, 125).build("generic_reaction", GenericReactionCategory::new);
        CreateRecipeCategory<ElectrolysisRecipe> electrolysis = this.builder(BasinRecipe.class).addTypedRecipes(DestroyRecipeTypes.ELECTROLYSIS).acceptsMixtures(ElectrolysisRecipe.class).catalyst(() -> DestroyBlocks.DYNAMO.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)DestroyBlocks.DYNAMO.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 85).build("electrolysis", (info, helpers) -> new ElectrolysisCategory((CreateRecipeCategory.Info<BasinRecipe>)info));
        MOLECULE_RECIPES_NEED_PROCESSING = false;
    }

    public ResourceLocation getPluginUid() {
        return Destroy.asResource("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        CategoryBuilder.helpers = registration.getJeiHelpers();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ExtendedDurationFireworkRocketRecipe.exampleRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(MoleculeJEIIngredient.TYPE, Molecule.MOLECULES.values(), MoleculeJEIIngredient.HELPER, MoleculeJEIIngredient.RENDERER);
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)((MixtureFluid)((Object)DestroyFluids.MIXTURE.get())).m_5613_(), (IIngredientSubtypeInterpreter)new MixtureFluidSubtypeInterpreter());
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)((MixtureFluid)((Object)DestroyFluids.MIXTURE.get())).m_5615_(), (IIngredientSubtypeInterpreter)new MixtureFluidSubtypeInterpreter());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new DestroyRecipeManagerPlugin(registration.getJeiHelpers()));
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        jeiRuntime = Optional.of(runtime);
    }

    public static void tick() {
        tickingCategories.forEach(ITickableCategory::tick);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private static IJeiHelpers helpers;
        private Class<? extends T> recipeClass;
        private IDrawable background;
        private IDrawable icon;
        private Class<? extends T> recipeClassForMixtures;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            this.recipeListConsumers.add(recipes -> recipes.addAll((Collection)collection.get()));
            Destroy.LOGGER.info("Loaded " + collection.get().size() + " recipes of type " + this.recipeClass.getSimpleName() + ".");
            return this;
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            this.recipeListConsumers.add(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)recipeTypeEntry.getType()));
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> itemSupplier) {
            this.catalysts.add(() -> new ItemStack((ItemLike)((ItemLike)itemSupplier.get()).m_5456_()));
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon = new ItemIcon(() -> new ItemStack(item));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike bigItem, ItemLike smallItem) {
            this.icon = new DoubleItemIcon(() -> new ItemStack(bigItem), () -> new ItemStack(smallItem));
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background = new EmptyBackground(width, height);
            return this;
        }

        public CategoryBuilder<T> acceptsMixtures() {
            this.recipeClassForMixtures = this.recipeClass;
            return this;
        }

        public CategoryBuilder<T> acceptsMixtures(Class<? extends T> actualRecipeClass) {
            this.recipeClassForMixtures = actualRecipeClass;
            return this;
        }

        public CreateRecipeCategory<T> build(String name, DestroyRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            };
            RecipeType type = new RecipeType(Destroy.asResource(name), this.recipeClass);
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(type, (Component)DestroyLang.translate("recipe." + name, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory<T> category = factory.create(info, helpers);
            DestroyJEI.this.allCategories.add(category);
            if (category instanceof ITickableCategory) {
                ITickableCategory tickableCategory = (ITickableCategory)category;
                tickingCategories.add(tickableCategory);
            }
            if (this.recipeClassForMixtures != null) {
                RECIPE_TYPES.put(type, this.recipeClassForMixtures);
            }
            return category;
        }
    }

    public class ClientEvents {
        @SubscribeEvent
        public static void onTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                DestroyJEI.tick();
            }
        }
    }
}

