/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei;

import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.compat.jei.DestroyJEI;
import com.petrolpark.destroy.compat.jei.MoleculeJEIIngredient;
import com.petrolpark.destroy.compat.jei.category.GenericReactionCategory;
import com.petrolpark.destroy.compat.jei.category.ReactionCategory;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.ingredient.MixtureFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.recipe.ReactionRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;

public class DestroyRecipeManagerPlugin
implements IRecipeManagerPlugin {
    private final IJeiHelpers helpers;

    public DestroyRecipeManagerPlugin(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        ArrayList recipeTypes = new ArrayList();
        if (focus.getTypedValue().getType() == MoleculeJEIIngredient.TYPE || focus.checkedCast((IIngredientType)ForgeTypes.FLUID_STACK).map(fluidFocus -> {
            FluidStack fluidStack = (FluidStack)fluidFocus.getTypedValue().getIngredient();
            return DestroyFluids.isMixture(fluidStack);
        }).orElse(false).booleanValue()) {
            recipeTypes.add(ReactionCategory.TYPE);
            recipeTypes.add(GenericReactionCategory.TYPE);
            recipeTypes.addAll(DestroyJEI.RECIPE_TYPES.keySet());
        }
        return recipeTypes;
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        focus.checkedCast((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fluidFocus -> {
            FluidStack fluidStack = (FluidStack)fluidFocus.getTypedValue().getIngredient();
            if (!DestroyFluids.isMixture(fluidStack)) {
                return;
            }
            MixtureFluidIngredientSubType<?> ingredientType = MixtureFluidIngredient.MIXTURE_FLUID_INGREDIENT_SUBTYPES.get(fluidStack.getOrCreateTag().m_128461_("MixtureFluidIngredientSubtype"));
            Collection<Object> molecules = List.of();
            if (ingredientType != null) {
                molecules = ingredientType.getContainedMolecules(fluidStack.getOrCreateTag());
            } else if (fluidStack.getOrCreateTag().m_128441_("Mixture")) {
                molecules = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, fluidStack.getOrCreateChildTag("Mixture")).getContents(true);
            }
            molecules.forEach(molecule -> recipes.addAll(this.getRecipes(recipeCategory, this.helpers.getFocusFactory().createFocus(focus.getRole(), MoleculeJEIIngredient.TYPE, molecule))));
        });
        Molecule molecule = focus.checkedCast(MoleculeJEIIngredient.TYPE).map(moleculeIngredient -> (Molecule)moleculeIngredient.getTypedValue().getIngredient()).orElse(null);
        if (molecule != null) {
            switch (focus.getRole()) {
                case INPUT: {
                    if (recipeCategory instanceof GenericReactionCategory) {
                        molecule.getFunctionalGroups().forEach(group -> Optional.ofNullable(Group.groupTypesAndReactions.get(group.getType())).ifPresent(set -> set.forEach(genericReaction -> {
                            ReactionRecipe recipe = GenericReactionCategory.RECIPES.get(genericReaction);
                            if (recipe != null) {
                                recipes.add((Object)recipe);
                            }
                        })));
                    } else if (recipeCategory instanceof ReactionCategory) {
                        molecule.getReactantReactions().forEach(reaction -> Optional.ofNullable(ReactionCategory.RECIPES.get(reaction)).ifPresent(recipes::add));
                    }
                    List<Recipe<?>> recipeUses = DestroyJEI.MOLECULES_INPUT.get(molecule);
                    if (recipeUses == null) break;
                    recipes.addAll(recipeUses.stream().filter(recipe -> recipe.getClass().equals(DestroyJEI.RECIPE_TYPES.get(recipeCategory.getRecipeType()))).map(recipe -> recipe).toList());
                    break;
                }
                case OUTPUT: {
                    if (recipeCategory instanceof GenericReactionCategory) {
                        molecule.getFunctionalGroups().forEach(group -> Optional.ofNullable(GenericReactionCategory.GROUP_RECIPES.get(group.getType())).ifPresent(set -> set.forEach(genericReaction -> {
                            ReactionRecipe recipe = GenericReactionCategory.RECIPES.get(genericReaction);
                            if (recipe != null) {
                                recipes.add((Object)recipe);
                            }
                        })));
                    } else if (recipeCategory instanceof ReactionCategory) {
                        molecule.getProductReactions().forEach(reaction -> Optional.ofNullable(ReactionCategory.RECIPES.get(reaction)).ifPresent(recipes::add));
                    }
                    List<Recipe<?>> recipeProductions = DestroyJEI.MOLECULES_OUTPUT.get(molecule);
                    if (recipeProductions == null) break;
                    recipes.addAll(recipeProductions.stream().filter(recipe -> recipe.getClass().equals(DestroyJEI.RECIPE_TYPES.get(recipeCategory.getRecipeType()))).map(recipe -> recipe).toList());
                    break;
                }
                case CATALYST: {
                    break;
                }
            }
        }
        return recipes;
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }
}

