/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.item.MoleculeDisplayItem;
import com.petrolpark.destroy.item.TestTubeItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class MoleculeJEIIngredient {
    private static final ItemStack illegalFish = new ItemStack((ItemLike)Items.f_42526_);
    public static final IIngredientType<Molecule> TYPE;
    public static final IIngredientHelper<Molecule> HELPER;
    public static final IIngredientRenderer<Molecule> RENDERER;

    static {
        illegalFish.m_41714_((Component)Component.m_237113_((String)"Impossible Fish"));
        TYPE = new IIngredientType<Molecule>(){

            public Class<? extends Molecule> getIngredientClass() {
                return Molecule.class;
            }
        };
        HELPER = new IIngredientHelper<Molecule>(){

            public IIngredientType<Molecule> getIngredientType() {
                return TYPE;
            }

            public String getDisplayName(Molecule ingredient) {
                return ingredient.getName(false).getString() + ingredient.getName(true).getString();
            }

            public String getUniqueId(Molecule ingredient, UidContext context) {
                return ingredient.getFullID();
            }

            public ResourceLocation getResourceLocation(Molecule ingredient) {
                if (ingredient.isNovel()) {
                    return Destroy.asResource("novel_molecule");
                }
                return new ResourceLocation(ingredient.getFullID());
            }

            public String getDisplayModId(Molecule ingredient) {
                if (ingredient.isNovel()) {
                    return "Destroy";
                }
                return super.getDisplayModId((Object)ingredient);
            }

            public Molecule copyIngredient(Molecule ingredient) {
                return ingredient;
            }

            public String getErrorInfo(@Nullable Molecule ingredient) {
                return ingredient == null ? "Molecule ingredient is null" : "Something is wrong with: " + ingredient.getFullID();
            }

            public ItemStack getCheatItemStack(Molecule ingredient) {
                if (ingredient.isHypothetical() || ingredient == DestroyMolecules.PROTON) {
                    return illegalFish;
                }
                return TestTubeItem.of(MixtureFluid.of(200, Mixture.pure(ingredient), ""));
            }
        };
        RENDERER = new IIngredientRenderer<Molecule>(){

            public void render(GuiGraphics graphics, Molecule ingredient) {
                graphics.m_280480_(MoleculeDisplayItem.with(ingredient), 0, 0);
            }

            public List<Component> getTooltip(Molecule ingredient, TooltipFlag tooltipFlag) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.add(ingredient.getName((Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get()));
                tooltips.addAll(MoleculeDisplayItem.getLore(ingredient));
                return tooltips;
            }
        };
    }
}

