/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.block.AgingBarrelBlock;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.client.gui.DestroyGuiTextures;
import com.petrolpark.destroy.compat.jei.animation.GUIBlockRenderer;
import com.petrolpark.destroy.compat.jei.category.DestroyRecipeCategory;
import com.petrolpark.destroy.recipe.AgingRecipe;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;

public class AgingCategory
extends DestroyRecipeCategory<AgingRecipe> {
    private static final GUIBlockRenderer blockRenderer = new GUIBlockRenderer();

    public AgingCategory(CreateRecipeCategory.Info<AgingRecipe> info, IJeiHelpers helpers) {
        super(info, helpers);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AgingRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_());
        int size = condensedIngredients.size();
        int xOffset = 8 + (size < 3 ? (3 - size) * 19 / 2 : 0);
        int i = 1;
        FluidIngredient fluidIngredient = recipe.getRequiredFluid();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, 33).setBackground(AgingCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, AgingCategory.withImprovedVisibility((List)fluidIngredient.getMatchingFluidStacks()))).addTooltipCallback(AgingCategory.addFluidTooltip((int)fluidIngredient.getRequiredAmount()));
        for (Pair pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).m_43908_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, xOffset + i % 3 * 19, 33).setBackground(AgingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        FluidStack resultantFluid = (FluidStack)recipe.getFluidResults().get(0);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 35).setBackground(AgingCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)AgingCategory.withImprovedVisibility((FluidStack)resultantFluid))).addTooltipCallback(AgingCategory.addFluidTooltip((int)resultantFluid.getAmount()));
    }

    public void draw(AgingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        PoseStack stack = graphics.m_280168_();
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 14);
        AllGuiTextures.JEI_SHADOW.render(graphics, 81, 50);
        stack.m_85836_();
        stack.m_252880_((float)(this.getBackground().getWidth() / 2 + 4), 51.0f, 0.0f);
        blockRenderer.renderBlock((BlockState)((BlockState)DestroyBlocks.AGING_BARREL.getDefaultState().m_61124_((Property)AgingBarrelBlock.IS_OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH), graphics, 23.0);
        stack.m_85849_();
        DestroyGuiTextures.JEI_TEXT_BOX_LONG.render(graphics, 4, 63);
        int seconds = recipe.getProcessingDuration() % 1200 / 20;
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, DestroyLang.translate("tooltip.aging_barrel.aging_time", recipe.getProcessingDuration() / 1200 + ":" + (seconds < 10 ? "0" : "") + seconds).string(), 9, 69, 0xFFFFFF, false);
    }
}

