/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei.category;

import com.google.common.collect.Sets;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.Group;
import com.petrolpark.destroy.chemistry.GroupType;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.genericreaction.GenericReaction;
import com.petrolpark.destroy.compat.jei.category.ReactionCategory;
import com.petrolpark.destroy.recipe.ReactionRecipe;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;

public class GenericReactionCategory
extends ReactionCategory<ReactionRecipe.GenericReactionRecipe> {
    public static RecipeType<ReactionRecipe.GenericReactionRecipe> TYPE;
    public static Map<GroupType<?>, Set<GenericReaction>> GROUP_RECIPES;
    public static Map<GenericReaction, ReactionRecipe.GenericReactionRecipe> RECIPES;

    public GenericReactionCategory(CreateRecipeCategory.Info<ReactionRecipe.GenericReactionRecipe> info, IJeiHelpers helpers) {
        super(info, helpers);
        TYPE = info.recipeType();
    }

    @Override
    protected String getTranslationKey(ReactionRecipe recipe) {
        if (recipe instanceof ReactionRecipe.GenericReactionRecipe) {
            ReactionRecipe.GenericReactionRecipe gRecipe = (ReactionRecipe.GenericReactionRecipe)recipe;
            ResourceLocation id = gRecipe.getGenericReaction().id;
            return id.m_135827_() + ".generic_reaction." + id.m_135815_();
        }
        return "";
    }

    static {
        GROUP_RECIPES = new HashMap();
        RECIPES = new HashMap<GenericReaction, ReactionRecipe.GenericReactionRecipe>();
        for (GenericReaction genericReaction : GenericReaction.GENERIC_REACTIONS) {
            Reaction reaction = null;
            try {
                reaction = genericReaction.getExampleReaction();
            }
            catch (Throwable e) {
                Destroy.LOGGER.warn("Problem generating generic reaction " + genericReaction.id);
            }
            if (reaction == null) continue;
            RECIPES.put(genericReaction, ReactionRecipe.GenericReactionRecipe.create(genericReaction));
            for (Molecule product : reaction.getProducts()) {
                if (!product.isNovel()) continue;
                for (Group<?> functionalGroup : product.getFunctionalGroups()) {
                    GROUP_RECIPES.merge(functionalGroup.getType(), Set.of(genericReaction), Sets::union);
                }
            }
        }
    }
}

