/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei.category;

import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.client.gui.stackedtextbox.AbstractStackedTextBox;
import com.petrolpark.destroy.client.gui.stackedtextbox.StackedTextBox;
import com.petrolpark.destroy.compat.jei.category.DestroyRecipeCategory;
import com.petrolpark.destroy.compat.jei.category.ITickableCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.crafting.Recipe;

public abstract class HoverableTextCategory<T extends Recipe<?>>
extends DestroyRecipeCategory<T>
implements ITickableCategory {
    private static final Map<Recipe<?>, Collection<AbstractStackedTextBox.LinesAndActivationAreas>> PARAGRAPHS = new HashMap();
    protected static AbstractStackedTextBox textBoxStack = AbstractStackedTextBox.NOTHING;

    public HoverableTextCategory(CreateRecipeCategory.Info<T> info, IJeiHelpers helpers) {
        super(info, helpers);
    }

    public abstract Collection<AbstractStackedTextBox.LinesAndActivationAreas> getHoverableTexts(T var1);

    public TooltipHelper.Palette getPaletteForBoxes() {
        return TooltipHelper.Palette.GRAY_AND_WHITE;
    }

    @Override
    public void tick() {
        textBoxStack.tick();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        textBoxStack = AbstractStackedTextBox.NOTHING;
        PARAGRAPHS.clear();
        PARAGRAPHS.put((Recipe<?>)recipe, this.getHoverableTexts(recipe));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        PoseStack stack = graphics.m_280168_();
        Collection<AbstractStackedTextBox.LinesAndActivationAreas> paragraphs = PARAGRAPHS.get(recipe);
        if (paragraphs == null) {
            return;
        }
        float partialTicks = AnimationTickHolder.getPartialTicks();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        for (AbstractStackedTextBox.LinesAndActivationAreas paragraph : paragraphs) {
            for (int i = 0; i < paragraph.lines().size(); ++i) {
                int n = paragraph.startX();
                int n2 = paragraph.startY();
                Objects.requireNonNull(font);
                graphics.m_280614_(font, paragraph.lines().get(i), n, n2 + i * 9, 0xFFFFFF, false);
            }
        }
        if (!textBoxStack.m_142518_()) {
            block2: for (AbstractStackedTextBox.LinesAndActivationAreas paragraph : paragraphs) {
                for (Pair<AbstractStackedTextBox.Area, String> pair : paragraph.areas()) {
                    if (!((AbstractStackedTextBox.Area)pair.getFirst()).isIn((int)mouseX, (int)mouseY)) continue;
                    textBoxStack = new StackedTextBox(minecraft, (int)mouseX, (int)mouseY, AbstractStackedTextBox.NOTHING).withActivationArea((AbstractStackedTextBox.Area)pair.getFirst()).withPalette(this.getPaletteForBoxes()).withText((String)pair.getSecond());
                    break block2;
                }
            }
        }
        stack.m_85836_();
        stack.m_252880_(10.0f, 0.0f, 0.0f);
        textBoxStack.m_88315_(graphics, (int)mouseX, (int)mouseY, partialTicks);
        stack.m_85849_();
    }
}

