/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.client.gui.DestroyGuiTextures;
import com.petrolpark.destroy.compat.jei.animation.GUIBlockRenderer;
import com.petrolpark.destroy.compat.jei.category.DestroyRecipeCategory;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.recipe.MutationRecipe;
import com.petrolpark.destroy.util.CropMutation;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MutationCategory
extends DestroyRecipeCategory<MutationRecipe> {
    public static final List<MutationRecipe> RECIPES = new ArrayList<MutationRecipe>();
    private static final GUIBlockRenderer blockRenderer = new GUIBlockRenderer();
    private static final int BLOCK_SCALE = 23;
    private static final int LEFT_BLOCK_X = 11;
    private static final int RIGHT_BLOCK_X = 79;
    private static final int BOTTOM_BLOCK_Y = 90;
    private static final BlockState farmlandBlock = (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7));

    public MutationCategory(CreateRecipeCategory.Info<MutationRecipe> info, IJeiHelpers helpers) {
        super(info, helpers);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MutationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 52, 40).setBackground(MutationCategory.getRenderedSlot(), -1, -1).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DestroyItems.HYPERACCUMULATING_FERTILIZER.get()}));
        builder.addSlot(RecipeIngredientRole.INPUT, 18, 3).setBackground(MutationCategory.getRenderedSlot(), -1, -1).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{recipe.getMutation().getStartCropSupplier().get().m_5456_()}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 3).setBackground(MutationCategory.getRenderedSlot(), -1, -1).addItemStack(new ItemStack((ItemLike)recipe.getMutation().getResultantCropSupplier().get().m_60734_().m_5456_(), 1));
        if (recipe.getMutation().isOreSpecific()) {
            Block oreBlock = recipe.getMutation().getOreSupplier().get();
            builder.addSlot(RecipeIngredientRole.INPUT, 18, 106).setBackground(MutationCategory.getRenderedSlot(), -1, -1).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{oreBlock}));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 106).setBackground(MutationCategory.getRenderedSlot(), -1, -1).addItemStack(new ItemStack((ItemLike)recipe.getMutation().getResultantBlockUnder(oreBlock.m_49966_()).m_60734_().m_5456_(), 1));
        }
    }

    public void draw(MutationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        PoseStack stack = graphics.m_280168_();
        BlockState startOreBlock = recipe.getMutation().isOreSpecific() ? recipe.getMutation().getOreSupplier().get().m_49966_() : Blocks.f_50069_.m_49966_();
        BlockState endOreBlock = recipe.getMutation().getResultantBlockUnder(startOreBlock);
        AllGuiTextures.JEI_SHADOW.render(graphics, 0, 88);
        AllGuiTextures.JEI_SHADOW.render(graphics, 68, 88);
        DestroyGuiTextures.JEI_SHORT_RIGHT_ARROW.render(graphics, 52, 60);
        stack.m_85836_();
        stack.m_252880_(11.0f, 90.0f, 200.0f);
        blockRenderer.renderBlock(startOreBlock, graphics, 23.0);
        stack.m_252880_(0.0f, -22.0f, 11.5f);
        blockRenderer.renderBlock(farmlandBlock, graphics, 23.0);
        stack.m_252880_(0.0f, -22.0f, 11.5f);
        blockRenderer.renderBlock(recipe.getMutation().getStartCropSupplier().get().m_49966_(), graphics, 23.0);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252880_(79.0f, 90.0f, 200.0f);
        blockRenderer.renderBlock(endOreBlock, graphics, 23.0);
        stack.m_252880_(0.0f, -22.0f, 11.5f);
        blockRenderer.renderBlock(farmlandBlock, graphics, 23.0);
        stack.m_252880_(0.0f, -22.0f, 11.5f);
        blockRenderer.renderBlock(recipe.getMutation().getResultantCropSupplier().get(), graphics, 23.0);
        stack.m_85849_();
    }

    static {
        for (List<CropMutation> mutations : CropMutation.MUTATIONS.values()) {
            for (CropMutation mutation : mutations) {
                RECIPES.add(MutationRecipe.create(mutation));
            }
        }
    }
}

