/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.compat.jei.category;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.chemistry.IItemReactant;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.chemistry.reactionresult.CombinedReactionResult;
import com.petrolpark.destroy.chemistry.reactionresult.PrecipitateReactionResult;
import com.petrolpark.destroy.client.gui.DestroyGuiTextures;
import com.petrolpark.destroy.client.gui.stackedtextbox.AbstractStackedTextBox;
import com.petrolpark.destroy.compat.jei.MoleculeJEIIngredient;
import com.petrolpark.destroy.compat.jei.ReactionTooltipHelper;
import com.petrolpark.destroy.compat.jei.animation.DestroyGuiTextureDrawable;
import com.petrolpark.destroy.compat.jei.category.HoverableTextCategory;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.recipe.ReactionRecipe;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.joml.Vector2i;

public class ReactionCategory<T extends ReactionRecipe>
extends HoverableTextCategory<T> {
    private static final int yOffset = 32;
    public static final TooltipHelper.Palette DARK_GRAY_AND_BLUE = TooltipHelper.Palette.ofColors((ChatFormatting)ChatFormatting.DARK_GRAY, (ChatFormatting)ChatFormatting.BLUE);
    public static final TooltipHelper.Palette WHITE_AND_AQUA = TooltipHelper.Palette.ofColors((ChatFormatting)ChatFormatting.WHITE, (ChatFormatting)ChatFormatting.AQUA);
    public static final TooltipHelper.Palette WHITE_AND_WHITE = TooltipHelper.Palette.ofColors((ChatFormatting)ChatFormatting.WHITE, (ChatFormatting)ChatFormatting.WHITE);
    public static RecipeType<? extends ReactionRecipe> TYPE;
    public static final Map<Reaction, ReactionRecipe> RECIPES;

    public ReactionCategory(CreateRecipeCategory.Info<T> info, IJeiHelpers helpers) {
        super(info, helpers);
        if (TYPE == null) {
            TYPE = info.recipeType();
        }
    }

    @Override
    public Collection<AbstractStackedTextBox.LinesAndActivationAreas> getHoverableTexts(ReactionRecipe recipe) {
        Reaction reaction = recipe.getReaction();
        if (reaction.getId() == null && !(recipe instanceof ReactionRecipe.GenericReactionRecipe)) {
            return List.of();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ArrayList<AbstractStackedTextBox.LinesAndActivationAreas> paragraphs = new ArrayList<AbstractStackedTextBox.LinesAndActivationAreas>(2);
        paragraphs.add(AbstractStackedTextBox.getTextAndActivationAreas(Component.m_237115_((String)this.getTranslationKey(recipe)).getString(), 2, 2, 176, minecraft.f_91080_, minecraft.f_91062_, DARK_GRAY_AND_BLUE, false));
        paragraphs.add(AbstractStackedTextBox.getTextAndActivationAreas(Component.m_237115_((String)(this.getTranslationKey(recipe) + ".description")).getString(), 2, 90, 176, minecraft.f_91080_, minecraft.f_91062_, DARK_GRAY_AND_BLUE, false));
        if (reaction.needsUV()) {
            Vector2i pos = this.getCatalystRenderPosition(0, this.getNumberOfCatalysts(reaction));
            paragraphs.add(AbstractStackedTextBox.getTextAndActivationAreas(DestroyLang.translate("tooltip.reaction.ultraviolet", new Object[0]).string(), pos.x + 3, pos.y + 4, 100, minecraft.f_91080_, minecraft.f_91062_, WHITE_AND_WHITE, false));
        }
        return paragraphs;
    }

    protected String getTranslationKey(ReactionRecipe recipe) {
        Reaction reaction = recipe.getReaction();
        return reaction.getNameSpace() + ".reaction." + reaction.getId();
    }

    @Override
    public TooltipHelper.Palette getPaletteForBoxes() {
        return WHITE_AND_AQUA;
    }

    private static void tooManyMoleculesWarning(boolean reactants, Reaction reaction) {
        Destroy.LOGGER.warn("Reaction '" + reaction.getFullId() + "' has too many " + (reactants ? "reactants" : "products") + " to fit on JEI.");
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        Vector2i pos;
        super.setRecipe(builder, recipe, focuses);
        Reaction reaction = ((ReactionRecipe)((Object)recipe)).getReaction();
        int i = 0;
        int numberOfReactants = reaction.getReactants().size() + reaction.getItemReactants().stream().filter(ir -> !ir.isCatalyst()).toList().size();
        if (numberOfReactants >= 6) {
            ReactionCategory.tooManyMoleculesWarning(true, reaction);
        }
        int reactantsXOffset = 5;
        if (numberOfReactants < 5) {
            if (numberOfReactants % 2 == 0) {
                reactantsXOffset += 9;
            } else if (numberOfReactants == 1) {
                reactantsXOffset += 19;
            }
        }
        int reactantYOffset = 32;
        if (numberOfReactants <= 3) {
            reactantYOffset += 9;
        }
        int k = numberOfReactants == 4 ? 2 : 3;
        for (Molecule reactant : reaction.getReactants()) {
            if (i >= 6) continue;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, reactantsXOffset + 19 * (i % k), reactantYOffset + i / k * 19).addIngredient(MoleculeJEIIngredient.TYPE, (Object)reactant)).addTooltipCallback(ReactionTooltipHelper.reactantTooltip(reaction, reactant)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++i;
        }
        for (IItemReactant itemReactant : reaction.getItemReactants()) {
            if (i >= 6 || itemReactant.isCatalyst()) continue;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, reactantsXOffset + 19 * (i % k), reactantYOffset + i / k * 19).addItemStacks(itemReactant.getDisplayedItemStacks())).addTooltipCallback(ReactionTooltipHelper.itemReactantTooltip(reaction, itemReactant)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++i;
        }
        ArrayList<PrecipitateReactionResult> precipitates = new ArrayList<PrecipitateReactionResult>();
        if (reaction.hasResult()) {
            Object object = reaction.getResult();
            if (object instanceof PrecipitateReactionResult) {
                PrecipitateReactionResult precipitate = (PrecipitateReactionResult)object;
                precipitates.add(precipitate);
            } else {
                object = reaction.getResult();
                if (object instanceof CombinedReactionResult) {
                    CombinedReactionResult combinedResults = (CombinedReactionResult)object;
                    for (ReactionResult combinedResult : combinedResults.getChildren()) {
                        if (!(combinedResult instanceof PrecipitateReactionResult)) continue;
                        PrecipitateReactionResult precipitate = (PrecipitateReactionResult)combinedResult;
                        precipitates.add(precipitate);
                    }
                }
            }
        }
        int j = 0;
        int numberOfProducts = reaction.getProducts().size() + precipitates.size();
        if (numberOfProducts >= 6) {
            ReactionCategory.tooManyMoleculesWarning(false, reaction);
        }
        int productsXOffset = 120;
        if (numberOfProducts < 5) {
            if (numberOfProducts % 2 == 0) {
                productsXOffset += 9;
            } else if (numberOfProducts == 1) {
                productsXOffset += 19;
            }
        }
        int productYOffset = 32;
        if (numberOfProducts <= 3) {
            productYOffset += 9;
        }
        int l = numberOfProducts == 4 ? 2 : 3;
        for (Molecule product : reaction.getProducts()) {
            if (j >= 6) continue;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, productsXOffset + 19 * (j % l), productYOffset + j / l * 19).addIngredient(MoleculeJEIIngredient.TYPE, (Object)product)).addTooltipCallback(ReactionTooltipHelper.productTooltip(reaction, product)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++j;
        }
        for (PrecipitateReactionResult precipitate : precipitates) {
            if (j >= 6) continue;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, productsXOffset + 19 * (j % l), productYOffset + j / l * 19).addItemStack(precipitate.getPrecipitate())).addTooltipCallback(ReactionTooltipHelper.precipitateTooltip(reaction, precipitate)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++j;
        }
        int numberOfCatalysts = this.getNumberOfCatalysts(reaction);
        int m = 0;
        if (reaction.needsUV()) {
            ++m;
        }
        for (Molecule catalyst : reaction.getOrders().keySet()) {
            if (reaction.getReactants().contains(catalyst)) continue;
            pos = this.getCatalystRenderPosition(m, numberOfCatalysts);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, pos.x, pos.y).addIngredient(MoleculeJEIIngredient.TYPE, (Object)catalyst)).addTooltipCallback(ReactionTooltipHelper.catalystTooltip(reaction, catalyst)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++m;
        }
        for (IItemReactant itemReactant : reaction.getItemReactants()) {
            if (!itemReactant.isCatalyst()) continue;
            pos = this.getCatalystRenderPosition(m, numberOfCatalysts);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, pos.x, pos.y).addItemStacks(itemReactant.getDisplayedItemStacks())).addTooltipCallback(ReactionTooltipHelper.itemReactantTooltip(reaction, itemReactant)).setBackground(ReactionCategory.getRenderedSlot(), -1, -1);
            ++m;
        }
        if (((Boolean)DestroyAllConfigs.CLIENT.chemistry.nerdMode.get()).booleanValue()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 163, 68).setOverlay((IDrawable)DestroyGuiTextureDrawable.of(DestroyGuiTextures.NERD_EMOJI), 0, 1).addItemStack(DestroyItems.ABS.asStack())).addTooltipCallback(ReactionTooltipHelper.nerdModeTooltip(reaction));
        }
    }

    protected Vector2i getCatalystRenderPosition(int position, int numberOfCatalysts) {
        if (position >= numberOfCatalysts) {
            return new Vector2i(0, 0);
        }
        int y = position >= 2 ? 24 : 58;
        int x = numberOfCatalysts % 2 == 0 || numberOfCatalysts == 3 && position <= 1 ? 70 + position % 2 * 19 : 78;
        return new Vector2i(x, y);
    }

    protected int getNumberOfCatalysts(Reaction reaction) {
        int number = 0;
        for (Molecule molecule : reaction.getOrders().keySet()) {
            if (reaction.getReactants().contains(molecule)) continue;
            ++number;
        }
        for (IItemReactant itemReactant : reaction.getItemReactants()) {
            if (!itemReactant.isCatalyst()) continue;
            ++number;
        }
        if (reaction.needsUV()) {
            ++number;
        }
        return number;
    }

    @Override
    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        DestroyGuiTextures.JEI_LINE.render(graphics, 2, 12);
        DestroyGuiTextures.JEI_LINE.render(graphics, 2, 85);
        ((ScreenElement)(((ReactionRecipe)((Object)recipe)).getReaction().displayAsReversible() ? DestroyGuiTextures.JEI_EQUILIBRIUM_ARROW : AllGuiTextures.JEI_ARROW)).render(graphics, 69, 46);
    }

    static {
        RECIPES = new HashMap<Reaction, ReactionRecipe>();
        for (Reaction reaction : Reaction.REACTIONS.values()) {
            ReactionRecipe recipe = ReactionRecipe.create(reaction);
            reaction.getReverseReactionForDisplay().ifPresent(reverseReaction -> RECIPES.put((Reaction)reverseReaction, recipe));
            if (!reaction.includeInJei()) continue;
            RECIPES.put(reaction, recipe);
        }
    }
}

