/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.config;

import com.petrolpark.destroy.config.DestroyClientConfigs;
import com.petrolpark.destroy.config.DestroyCommonConfigs;
import com.petrolpark.destroy.config.DestroyConfigBase;
import com.petrolpark.destroy.config.DestroyServerConfigs;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DestroyAllConfigs
extends AllConfigs {
    private static final Map<ModConfig.Type, DestroyConfigBase> CONFIGS = new EnumMap<ModConfig.Type, DestroyConfigBase>(ModConfig.Type.class);
    public static DestroyClientConfigs CLIENT;
    public static DestroyCommonConfigs COMMON;
    public static DestroyServerConfigs SERVER;

    private static <T extends DestroyConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            DestroyConfigBase config = (DestroyConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        DestroyConfigBase config = (DestroyConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void register(ModLoadingContext context) {
        CLIENT = DestroyAllConfigs.register(DestroyClientConfigs::new, ModConfig.Type.CLIENT);
        COMMON = DestroyAllConfigs.register(DestroyCommonConfigs::new, ModConfig.Type.COMMON);
        SERVER = DestroyAllConfigs.register(DestroyServerConfigs::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, DestroyConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (DestroyConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (DestroyConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

