/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.effect;

import com.petrolpark.destroy.capability.entity.EntityChemicalPoison;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.effect.DestroyMobEffect;
import com.petrolpark.destroy.effect.DestroyMobEffects;
import com.petrolpark.destroy.effect.UncurableMobEffect;
import com.petrolpark.destroy.world.damage.DestroyDamageSources;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.common.util.LazyOptional;

public class ChemicalPoisonMobEffect
extends UncurableMobEffect {
    protected ChemicalPoisonMobEffect() {
        super(MobEffectCategory.HARMFUL, 0xFFFFFF);
    }

    @Override
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new ChemicalPoisonMobEffectExtensions());
    }

    public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(livingEntity, attributeMap, amplifier);
        EntityChemicalPoison.removeMolecule((Entity)livingEntity);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        int duration;
        if (!livingEntity.m_9236_().m_5776_() && (duration = livingEntity.m_21124_((MobEffect)DestroyMobEffects.CHEMICAL_POISON.get()).m_19557_()) % 50 == 0) {
            Molecule molecule = null;
            LazyOptional<EntityChemicalPoison> cap = ChemicalPoisonMobEffect.getCap(livingEntity);
            if (cap.isPresent()) {
                molecule = ((EntityChemicalPoison)cap.resolve().get()).getMolecule();
            }
            livingEntity.m_6469_((DamageSource)DestroyDamageSources.chemicalPoison(livingEntity.m_9236_(), molecule), 1.0f);
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    private static LazyOptional<EntityChemicalPoison> getCap(LivingEntity livingEntity) {
        return livingEntity.getCapability(EntityChemicalPoison.Provider.ENTITY_CHEMICAL_POISON);
    }

    public static class ChemicalPoisonMobEffectExtensions
    extends DestroyMobEffect.DestroyMobEffectExtensions {
        @Override
        public void addToTooltip(List<Component> tooltip, MobEffectInstance instance) {
            super.addToTooltip(tooltip, instance);
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null) {
                minecraft.f_91074_.getCapability(EntityChemicalPoison.Provider.ENTITY_CHEMICAL_POISON).ifPresent(cp -> {
                    Molecule molecule = cp.getMolecule();
                    if (molecule != null) {
                        tooltip.set(0, (Component)Component.m_237110_((String)"effect.destroy.chemical_poison.molecule", (Object[])new Object[]{cp.getMolecule().getName((Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get())}));
                    }
                });
            }
        }
    }
}

