/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.entity;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.PrimeableBombBlock;
import com.petrolpark.destroy.entity.DestroyEntityTypes;
import com.petrolpark.destroy.util.ExplosionHelper;
import com.petrolpark.destroy.world.explosion.AnfoExplosion;
import com.petrolpark.destroy.world.explosion.DebrisMiningExplosion;
import com.petrolpark.destroy.world.explosion.ObliterationExplosion;
import com.petrolpark.destroy.world.explosion.SmartExplosion;
import com.petrolpark.destroy.world.explosion.UnderwaterExplosion;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class PrimedBomb
extends PrimedTnt {
    @Nullable
    protected LivingEntity owner;

    public PrimedBomb(EntityType<? extends PrimedTnt> entityType, Level level) {
        super(entityType, level);
    }

    protected PrimedBomb(EntityType<? extends PrimedTnt> entityType, Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity owner) {
        super(entityType, level);
        int n;
        Block block;
        Vec3 pos = Vec3.m_82539_((Vec3i)blockPos);
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.f_19854_ = pos.f_82479_;
        this.f_19855_ = pos.f_82480_;
        this.f_19856_ = pos.f_82481_;
        this.owner = owner;
        if (state != null && (block = state.m_60734_()) instanceof PrimeableBombBlock) {
            PrimeableBombBlock primeableBombBlock = (PrimeableBombBlock)block;
            n = primeableBombBlock.getFuseTime(level, blockPos, state);
        } else {
            n = 80;
        }
        this.m_32085_(n);
    }

    protected void m_32103_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ExplosionHelper.explode(serverLevel, this.getExplosion((Level)serverLevel, this.f_19825_, (Entity)this));
        }
    }

    @Nullable
    public LivingEntity m_19749_() {
        return this.owner;
    }

    public abstract BlockState getBlockStateToRender();

    public abstract SmartExplosion getExplosion(Level var1, Vec3 var2, @Nullable Entity var3);

    public static class Nitrocellulose
    extends PrimedBomb {
        public Nitrocellulose(EntityType<? extends PrimedTnt> entityType, Level level) {
            super(entityType, level);
        }

        public Nitrocellulose(Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity owner) {
            super((EntityType<? extends PrimedTnt>)((EntityType)DestroyEntityTypes.PRIMED_NITROCELLULOSE.get()), level, blockPos, state, owner);
        }

        @Override
        public BlockState getBlockStateToRender() {
            return DestroyBlocks.NITROCELLULOSE_BLOCK.getDefaultState();
        }

        @Override
        public SmartExplosion getExplosion(Level level, Vec3 position, @Nullable Entity source) {
            return new ObliterationExplosion(level, source, null, null, position, 3.0f, 0.8f);
        }
    }

    public static class Cordite
    extends PrimedBomb {
        public Cordite(EntityType<? extends PrimedTnt> entityType, Level level) {
            super(entityType, level);
        }

        public Cordite(Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity owner) {
            super((EntityType<? extends PrimedTnt>)((EntityType)DestroyEntityTypes.PRIMED_CORDITE.get()), level, blockPos, state, owner);
        }

        @Override
        public BlockState getBlockStateToRender() {
            return DestroyBlocks.CORDITE.getDefaultState();
        }

        @Override
        public SmartExplosion getExplosion(Level level, Vec3 position, @Nullable Entity source) {
            return new DebrisMiningExplosion(level, source, position, 10.0f, 0.6f);
        }
    }

    public static class PicricAcid
    extends PrimedBomb {
        public PicricAcid(EntityType<? extends PrimedTnt> entityType, Level level) {
            super(entityType, level);
        }

        public PicricAcid(Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity owner) {
            super((EntityType<? extends PrimedTnt>)((EntityType)DestroyEntityTypes.PRIMED_PICRIC_ACID.get()), level, blockPos, state, owner);
        }

        @Override
        public BlockState getBlockStateToRender() {
            return DestroyBlocks.PICRIC_ACID_BLOCK.getDefaultState();
        }

        @Override
        public SmartExplosion getExplosion(Level level, Vec3 position, @Nullable Entity source) {
            return new UnderwaterExplosion(level, source, position, 5.0f, 0.6f);
        }
    }

    public static class Anfo
    extends PrimedBomb {
        public Anfo(EntityType<? extends PrimedTnt> entityType, Level level) {
            super(entityType, level);
        }

        public Anfo(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity owner) {
            super((EntityType<? extends PrimedTnt>)((EntityType)DestroyEntityTypes.PRIMED_ANFO.get()), level, pos, state, owner);
        }

        @Override
        public SmartExplosion getExplosion(Level level, Vec3 position, @Nullable Entity source) {
            return new AnfoExplosion(level, source, position, 5.0f, 0.6f);
        }

        @Override
        public BlockState getBlockStateToRender() {
            return DestroyBlocks.ANFO_BLOCK.getDefaultState();
        }
    }
}

