/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.events;

import com.jozufozu.flywheel.util.Color;
import com.petrolpark.destroy.block.renderer.BlockEntityBehaviourRenderer;
import com.petrolpark.destroy.capability.level.pollution.ClientLevelPollutionData;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.client.gui.button.OpenDestroyMenuButton;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.item.SwissArmyKnifeItem;
import com.petrolpark.destroy.item.renderer.SeismometerItemRenderer;
import com.petrolpark.destroy.mixin.accessor.MenuRowsAccessor;
import com.petrolpark.destroy.util.CogwheelChainingHandler;
import com.petrolpark.destroy.util.PollutionHelper;
import com.simibubi.create.infrastructure.gui.OpenCreateMenuButton;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DestroyClientEvents {
    @Nonnull
    private static Color BROWN = new Color(-11718887);

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CogwheelChainingHandler.tick();
            SeismometerItemRenderer.tick();
            SwissArmyKnifeItem.clientPlayerTick();
        } else {
            BlockEntityBehaviourRenderer.tick();
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        if (!DestroyClientEvents.smogEnabled()) {
            return;
        }
        if (event.getType() == FogType.NONE) {
            LevelPollution levelPollution = ClientLevelPollutionData.getLevelPollution();
            if (levelPollution == null) {
                return;
            }
            event.scaleNearPlaneDistance(1.0f - 0.8f * (float)levelPollution.get(LevelPollution.PollutionType.SMOG) / (float)LevelPollution.PollutionType.SMOG.max);
            event.scaleFarPlaneDistance(1.0f - 0.5f * (float)levelPollution.get(LevelPollution.PollutionType.SMOG) / (float)LevelPollution.PollutionType.SMOG.max);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void colorFog(ViewportEvent.ComputeFogColor event) {
        if (!DestroyClientEvents.smogEnabled()) {
            return;
        }
        if (event.getCamera().m_167685_() == FogType.NONE) {
            LevelPollution levelPollution = ClientLevelPollutionData.getLevelPollution();
            if (levelPollution == null) {
                return;
            }
            Color existing = new Color(event.getRed(), event.getGreen(), event.getBlue(), 1.0f);
            Color color = Color.mixColors((Color)existing, (Color)BROWN, (float)(0.8f * (float)levelPollution.get(LevelPollution.PollutionType.SMOG) / (float)LevelPollution.PollutionType.SMOG.max));
            event.setRed(color.getRedAsFloat());
            event.setGreen(color.getGreenAsFloat());
            event.setBlue(color.getBlueAsFloat());
        }
    }

    public static boolean smogEnabled() {
        return PollutionHelper.pollutionEnabled() && (Boolean)DestroyAllConfigs.SERVER.pollution.smog.get() != false;
    }

    @SubscribeEvent
    public static void onGuiInit(ScreenEvent.Init event) {
        Screen gui = event.getScreen();
        OpenCreateMenuButton.MenuRows menu = null;
        int rowIdx = 0;
        int offsetX = 0;
        if (gui instanceof TitleScreen) {
            menu = OpenCreateMenuButton.MenuRows.MAIN_MENU;
            rowIdx = (Integer)DestroyAllConfigs.CLIENT.configurationButtons.mainMenuConfigButtonRow.get();
            offsetX = (Integer)DestroyAllConfigs.CLIENT.configurationButtons.mainMenuConfigButtonOffsetX.get();
        } else if (gui instanceof PauseScreen) {
            menu = OpenCreateMenuButton.MenuRows.INGAME_MENU;
            rowIdx = (Integer)DestroyAllConfigs.CLIENT.configurationButtons.pauseMenuConfigButtonRow.get();
            offsetX = (Integer)DestroyAllConfigs.CLIENT.configurationButtons.pauseMenuConfigButtonOffsetX.get();
        }
        if (rowIdx != 0 && menu != null) {
            boolean onLeft = offsetX < 0;
            String target = (onLeft ? ((MenuRowsAccessor)menu).getLeftButtons() : ((MenuRowsAccessor)menu).getLeftButtons()).get(rowIdx - 1);
            int offsetX_ = offsetX;
            MutableObject toAdd = new MutableObject(null);
            event.getListenersList().stream().filter(w -> w instanceof AbstractWidget).map(w -> (AbstractWidget)w).filter(w -> w.m_6035_().getString().equals(target)).findFirst().ifPresent(w -> toAdd.setValue((Object)new OpenDestroyMenuButton(w.m_252754_() + offsetX_ + (onLeft ? -20 : w.m_5711_()), w.m_252907_())));
            if (toAdd.getValue() != null) {
                event.addListener((GuiEventListener)toAdd.getValue());
            }
        }
    }
}

