/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.events;

import com.mojang.brigadier.CommandDispatcher;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.MoveToPetrolparkLibrary;
import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.badge.BadgeHandler;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.ExtendedBasinBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.PollutingBehaviour;
import com.petrolpark.destroy.capability.chunk.ChunkCrudeOil;
import com.petrolpark.destroy.capability.entity.EntityChemicalPoison;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.capability.level.pollution.LevelPollutionProvider;
import com.petrolpark.destroy.capability.player.PlayerBadges;
import com.petrolpark.destroy.capability.player.PlayerCrouching;
import com.petrolpark.destroy.capability.player.babyblue.PlayerBabyBlueAddiction;
import com.petrolpark.destroy.capability.player.babyblue.PlayerBabyBlueAddictionProvider;
import com.petrolpark.destroy.capability.player.previousposition.PlayerPreviousPositions;
import com.petrolpark.destroy.capability.player.previousposition.PlayerPreviousPositionsProvider;
import com.petrolpark.destroy.commands.BabyBlueAddictionCommand;
import com.petrolpark.destroy.commands.CrudeOilCommand;
import com.petrolpark.destroy.commands.PollutionCommand;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.effect.DestroyMobEffects;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.item.RedstoneProgrammerBlockItem;
import com.petrolpark.destroy.item.SyringeItem;
import com.petrolpark.destroy.item.TestTubeItem;
import com.petrolpark.destroy.network.DestroyMessages;
import com.petrolpark.destroy.network.packet.LevelPollutionS2CPacket;
import com.petrolpark.destroy.network.packet.SeismometerSpikeS2CPacket;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.petrolpark.destroy.util.ChemistryDamageHelper;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.DestroyTags;
import com.petrolpark.destroy.util.InebriationHelper;
import com.petrolpark.destroy.util.PollutionHelper;
import com.petrolpark.destroy.util.RedstoneProgrammerItemHandler;
import com.petrolpark.destroy.world.damage.DestroyDamageSources;
import com.petrolpark.destroy.world.entity.goal.BuildSandCastleGoal;
import com.petrolpark.destroy.world.village.DestroyTrades;
import com.petrolpark.destroy.world.village.DestroyVillageAddition;
import com.petrolpark.destroy.world.village.DestroyVillagers;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.api.event.BlockEntityBehaviourEvent;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockItem;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.ModFilePackResources;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;

@Mod.EventBusSubscriber(modid="destroy")
public class DestroyCommonEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesLevel(AttachCapabilitiesEvent<Level> event) {
        Level level = (Level)event.getObject();
        if (!level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).isPresent()) {
            event.addCapability(Destroy.asResource("pollution"), (ICapabilityProvider)new LevelPollutionProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object;
        Entity entity = (Entity)event.getObject();
        if (entity instanceof LivingEntity && !entity.getCapability(EntityChemicalPoison.Provider.ENTITY_CHEMICAL_POISON).isPresent()) {
            event.addCapability(Destroy.asResource("chemical_poison"), (ICapabilityProvider)new EntityChemicalPoison.Provider());
        }
        if ((object = event.getObject()) instanceof Player) {
            Player player = (Player)object;
            if (!player.getCapability(PlayerBabyBlueAddictionProvider.PLAYER_BABY_BLUE_ADDICTION).isPresent()) {
                event.addCapability(Destroy.asResource("baby_blue_addiction"), (ICapabilityProvider)new PlayerBabyBlueAddictionProvider());
            }
            if (!player.getCapability(PlayerPreviousPositionsProvider.PLAYER_PREVIOUS_POSITIONS).isPresent()) {
                event.addCapability(Destroy.asResource("previous_positions"), (ICapabilityProvider)new PlayerPreviousPositionsProvider());
            }
            if (!player.getCapability(PlayerCrouching.Provider.PLAYER_CROUCHING).isPresent()) {
                event.addCapability(Destroy.asResource("crouching"), (ICapabilityProvider)new PlayerCrouching.Provider());
            }
            if (!player.getCapability(PlayerBadges.Provider.PLAYER_BADGES).isPresent()) {
                event.addCapability(Destroy.asResource("badges"), (ICapabilityProvider)new PlayerBadges.Provider());
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesChunk(AttachCapabilitiesEvent<LevelChunk> event) {
        LevelChunk chunk = (LevelChunk)event.getObject();
        if (!chunk.getCapability(ChunkCrudeOil.Provider.CHUNK_CRUDE_OIL).isPresent()) {
            event.addCapability(Destroy.asResource("crude_oil"), (ICapabilityProvider)new ChunkCrudeOil.Provider());
        }
    }

    @SubscribeEvent
    public static void onPlayerEntersWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = player.m_9236_();
        level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).ifPresent(levelPollution -> DestroyMessages.sendToClient(new LevelPollutionS2CPacket((LevelPollution)levelPollution), serverPlayer));
        BadgeHandler.fetchAndAddBadgesIncludingEarlyBird((Player)serverPlayer);
    }

    @SubscribeEvent
    public static void onEntityEntersDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MinecraftServer server = player.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel level = server.m_129880_(event.getDimension());
        if (level == null) {
            return;
        }
        level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).ifPresent(levelPollution -> DestroyMessages.sendToClient(new LevelPollutionS2CPacket((LevelPollution)levelPollution), player));
        player.getCapability(PlayerPreviousPositionsProvider.PLAYER_PREVIOUS_POSITIONS).ifPresent(previousPositions -> previousPositions.clearPositions());
    }

    @SubscribeEvent
    @MoveToPetrolparkLibrary
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerBabyBlueAddictionProvider.PLAYER_BABY_BLUE_ADDICTION).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerBabyBlueAddictionProvider.PLAYER_BABY_BLUE_ADDICTION).ifPresent(newStore -> newStore.copyFrom((PlayerBabyBlueAddiction)oldStore)));
            event.getOriginal().getCapability(PlayerBadges.Provider.PLAYER_BADGES).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerBadges.Provider.PLAYER_BADGES).ifPresent(newStore -> newStore.setBadges(oldStore.getBadges())));
        }
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new CrudeOilCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new BabyBlueAddictionCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new PollutionCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ChunkCrudeOil.class);
        event.register(LevelPollution.class);
        event.register(PlayerBabyBlueAddiction.class);
        event.register(PlayerPreviousPositions.class);
        event.register(PlayerCrouching.class);
        event.register(EntityChemicalPoison.class);
        event.register(PlayerBadges.class);
    }

    @SubscribeEvent
    public static void attachBasinBehaviours(BlockEntityBehaviourEvent<BasinBlockEntity> event) {
        BasinBlockEntity basin = (BasinBlockEntity)event.getBlockEntity();
        event.attach((BlockEntityBehaviour)new PollutingBehaviour((SmartBlockEntity)basin));
        event.attach((BlockEntityBehaviour)new ExtendedBasinBehaviour((SmartBlockEntity)basin));
    }

    @SubscribeEvent
    public static void attachDrainBehaviours(BlockEntityBehaviourEvent<ItemDrainBlockEntity> event) {
        event.attach((BlockEntityBehaviour)new PollutingBehaviour(event.getBlockEntity()));
    }

    @SubscribeEvent
    public static void attachSpoutBehaviours(BlockEntityBehaviourEvent<SpoutBlockEntity> event) {
        event.attach((BlockEntityBehaviour)new PollutingBehaviour(event.getBlockEntity()));
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == DestroyVillagers.INNKEEPER.get()) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).addAll(DestroyTrades.INNKEEPER_NOVICE_TRADES);
            ((List)trades.get(2)).addAll(DestroyTrades.INNKEEPER_APPRENTICE_TRADES);
            ((List)trades.get(3)).addAll(DestroyTrades.INNKEEPER_JOURNEYMAN_TRADES);
            ((List)trades.get(4)).addAll(DestroyTrades.INNKEEPER_EXPERT_TRADES);
            ((List)trades.get(5)).addAll(DestroyTrades.INNKEEPER_MASTER_TRADES);
        }
    }

    @SubscribeEvent
    public static void addVillagerBuildings(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        DestroyVillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "destroy:plains_inn", 5);
        DestroyVillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "destroy:desert_inn", 5);
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        boolean urinating;
        Player player = event.player;
        Level level = player.m_9236_();
        player.getCapability(PlayerPreviousPositionsProvider.PLAYER_PREVIOUS_POSITIONS).ifPresent(playerPreviousPositions -> {
            playerPreviousPositions.incrementTickCounter();
            if (playerPreviousPositions.hasBeenSecond()) {
                playerPreviousPositions.recordPosition(player.m_20183_());
            }
        });
        BlockPos posOn = player.m_20097_();
        BlockState stateOn = level.m_8055_(posOn);
        boolean bl = urinating = (stateOn.m_60734_() == Blocks.f_152476_ || stateOn.m_60734_() == Blocks.f_50256_) && player.m_21023_((MobEffect)DestroyMobEffects.INEBRIATION.get());
        if (player.m_6047_()) {
            player.getCapability(PlayerCrouching.Provider.PLAYER_CROUCHING).ifPresent(crouchingCap -> {
                ++crouchingCap.ticksCrouching;
                crouchingCap.ticksUrinating = urinating ? ++crouchingCap.ticksUrinating : 0;
            });
        } else {
            player.getCapability(PlayerCrouching.Provider.PLAYER_CROUCHING).ifPresent(crouchingCap -> {
                crouchingCap.ticksCrouching = 0;
                crouchingCap.ticksUrinating = 0;
            });
        }
        int ticksUrinating = player.getCapability(PlayerCrouching.Provider.PLAYER_CROUCHING).map(crouchingCap -> crouchingCap.ticksUrinating).orElse(0);
        if (ticksUrinating > 0) {
            Vec3 pos = player.m_20182_();
            if (level.m_5776_()) {
                level.m_7106_(FluidFX.getFluidParticle((FluidStack)new FluidStack((Fluid)DestroyFluids.URINE.get(), 1000)), pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 0.0, -0.07, 0.0);
            }
            if (ticksUrinating % 40 == 0) {
                DestroySoundEvents.URINATE.playOnServer(level, (Vec3i)posOn);
            }
            if (ticksUrinating == 119) {
                InebriationHelper.increaseInebriation((LivingEntity)player, -1);
                DestroyAdvancements.URINATE.award(level, player);
                level.m_46597_(posOn, DestroyBlocks.URINE_CAULDRON.getDefaultState());
            }
        }
        if (level.m_45527_(posOn.m_7494_()) && !player.m_21023_((MobEffect)DestroyMobEffects.SUN_PROTECTION.get()) && player.m_217043_().m_188503_(LevelPollution.PollutionType.OZONE_DEPLETION.max * 600) < PollutionHelper.getPollution(level, LevelPollution.PollutionType.OZONE_DEPLETION)) {
            player.m_7292_(DestroyMobEffects.cancerInstance());
        }
    }

    @SubscribeEvent
    public static void changeMiningSpeedWithBabyBlueEffects(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)DestroyMobEffects.BABY_BLUE_HIGH.get())) {
            event.setNewSpeed(event.getOriginalSpeed() + 0.5f * (float)(player.m_21124_((MobEffect)DestroyMobEffects.BABY_BLUE_HIGH.get()).m_19564_() + 1));
        } else if (player.m_21023_((MobEffect)DestroyMobEffects.BABY_BLUE_WITHDRAWAL.get())) {
            event.setNewSpeed(event.getOriginalSpeed() - 0.3f * (float)(player.m_21124_((MobEffect)DestroyMobEffects.BABY_BLUE_WITHDRAWAL.get()).m_19564_() + 1));
            if (event.getNewSpeed() <= 0.0f) {
                event.setNewSpeed(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void playerHearsSound(PlayLevelSoundEvent.AtPosition event) {
        if (event.getOriginalVolume() < 0.5f) {
            return;
        }
        switch (event.getSource()) {
            case AMBIENT: 
            case PLAYERS: 
            case MUSIC: 
            case VOICE: 
            case NEUTRAL: {
                break;
            }
            default: {
                Vec3 pos = event.getPosition();
                List nearbyEntities = event.getLevel().m_45933_(null, new AABB(pos.m_82549_(new Vec3(-5.0, -5.0, -5.0)), pos.m_82549_(new Vec3(5.0, 5.0, 5.0))));
                for (Entity entity : nearbyEntities) {
                    Player player;
                    if (!(entity instanceof Player) || !(player = (Player)entity).m_21023_((MobEffect)DestroyMobEffects.HANGOVER.get())) continue;
                    player.m_6469_(DestroyDamageSources.headache(player.m_9236_()), 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void disableEating(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (stack.m_41720_().m_41472_()) {
            if (DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_HEAD.matches(player.m_6844_(EquipmentSlot.HEAD).m_41720_())) {
                player.m_5661_((Component)DestroyLang.translate("tooltip.eating_prevented.gas_mask", new Object[0]).component(), true);
                event.setCanceled(true);
                return;
            }
            if (stack.m_41720_() != DestroyItems.BABY_BLUE_POWDER.get() && player.m_21023_((MobEffect)DestroyMobEffects.BABY_BLUE_WITHDRAWAL.get())) {
                player.m_5661_((Component)DestroyLang.translate("tooltip.eating_prevented.baby_blue", new Object[0]).component(), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void chainCogwheels(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public static void onPlayersWakeUp(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().m_6907_()) {
            MobEffectInstance effect = player.m_21124_((MobEffect)DestroyMobEffects.INEBRIATION.get());
            if (effect == null) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)DestroyMobEffects.HANGOVER.get(), (Integer)DestroyAllConfigs.COMMON.substances.hangoverDuration.get() * (effect.m_19564_() + 1)));
            player.m_21195_((MobEffect)DestroyMobEffects.INEBRIATION.get());
            DestroyAdvancements.HANGOVER.award(player.m_9236_(), player);
        }
    }

    @SubscribeEvent
    public static void onSyringeAttack(LivingAttackEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        ItemStack itemStack = livingAttacker.m_21205_();
        Item item = itemStack.m_41720_();
        if (!(item instanceof SyringeItem)) {
            return;
        }
        SyringeItem syringeItem = (SyringeItem)item;
        syringeItem.onInject(itemStack, attacker.m_9236_(), event.getEntity());
        livingAttacker.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)DestroyItems.SYRINGE.get()));
    }

    @SubscribeEvent
    public static void onJoinEntity(EntityJoinLevelEvent event) {
        Villager villager;
        Entity entity;
        PotatoProjectileEntity projectile;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof PotatoProjectileEntity && (entity2 = (projectile = (PotatoProjectileEntity)entity2).m_19749_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            if (DestroyTags.DestroyItemTags.HEFTY_BEETROOT.matches(projectile.getItem().m_41720_())) {
                DestroyAdvancements.SHOOT_HEFTY_BEETROOT.award(player.m_9236_(), (Player)player);
            }
        }
        if ((entity = event.getEntity()) instanceof Villager && (villager = (Villager)entity).m_6162_()) {
            villager.f_21345_.m_25352_(0, (Goal)new BuildSandCastleGoal((PathfinderMob)villager, true));
        }
    }

    @SubscribeEvent
    public static void rightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        LivingEntity livingEntity;
        Entity item;
        Entity entity;
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21120_(event.getHand());
        if (AllItems.EMPTY_BLAZE_BURNER.isIn(itemStack) && (entity = event.getTarget()) instanceof Stray) {
            Stray stray = (Stray)entity;
            item = (BlazeBurnerBlockItem)itemStack.m_41720_();
            if (item.hasCapturedBlaze()) {
                return;
            }
            event.getLevel().m_5594_(null, BlockPos.m_274446_((Position)stray.m_20182_()), SoundEvents.f_12453_, SoundSource.HOSTILE, 0.25f, 0.75f);
            stray.m_146870_();
            ItemStack filled = DestroyBlocks.COOLER.asStack();
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (itemStack.m_41619_()) {
                player.m_21008_(event.getHand(), filled);
            } else {
                player.m_150109_().m_150079_(filled);
            }
            DestroyAdvancements.CAPTURE_STRAY.award(event.getLevel(), player);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (itemStack.m_150930_(Items.f_42590_) && (item = event.getTarget()) instanceof LivingEntity && (livingEntity = (LivingEntity)item).m_21023_((MobEffect)DestroyMobEffects.CRYING.get())) {
            livingEntity.m_21195_((MobEffect)DestroyMobEffects.CRYING.get());
            ItemStack filled = DestroyItems.TEAR_BOTTLE.asStack();
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (itemStack.m_41619_()) {
                player.m_21008_(event.getHand(), filled);
            } else {
                player.m_150109_().m_150079_(filled);
            }
            DestroyAdvancements.COLLECT_TEARS.award(event.getLevel(), player);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity be;
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        LinkBehaviour link = (LinkBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LinkBehaviour.TYPE);
        if (event.getItemStack().m_41720_() instanceof RedstoneProgrammerBlockItem && link != null) {
            if (player.m_6144_()) {
                return;
            }
            RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, (LivingEntity)player).ifPresent(program -> {
                Couple key = link.getNetworkKey();
                if (program.getChannels().stream().anyMatch(channel -> channel.getNetworkKey().equals((Object)key))) {
                    event.setCancellationResult(InteractionResult.FAIL);
                    if (level.m_5776_()) {
                        player.m_5661_((Component)DestroyLang.translate("tooltip.redstone_programmer.add_frequency.failure", new Object[0]).style(ChatFormatting.RED).component(), true);
                    }
                } else {
                    program.addBlankChannel((Couple<RedstoneLinkNetworkHandler.Frequency>)link.getNetworkKey());
                    RedstoneProgrammerBlockItem.setProgram(stack, program);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    if (level.m_5776_()) {
                        player.m_5661_((Component)DestroyLang.translate("tooltip.redstone_programmer.add_frequency.success", ((RedstoneLinkNetworkHandler.Frequency)key.getFirst()).getStack().m_41786_(), ((RedstoneLinkNetworkHandler.Frequency)key.getSecond()).getStack().m_41786_()).component(), true);
                    }
                }
            });
            event.setCanceled(true);
        }
        if (stack.m_41720_() instanceof TestTubeItem && TestTubeItem.isEmpty(stack) && player.m_7500_() && !((be = level.m_7702_(pos)) instanceof VatSideBlockEntity) && !(be instanceof VatControllerBlockEntity) && be.getCapability(ForgeCapabilities.FLUID_HANDLER, event.getFace()).map(handler -> {
            FluidStack drained = handler.drain(200, IFluidHandler.FluidAction.SIMULATE);
            if (DestroyFluids.isMixture(drained)) {
                player.m_21008_(event.getHand(), TestTubeItem.of(drained));
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start event) {
        Level level = event.getLevel();
        level.m_6443_(Player.class, AABB.m_165882_((Vec3)event.getExplosion().getPosition(), (double)16.0, (double)16.0, (double)16.0), player -> true).forEach(player -> {
            boolean holdingSeismometer = false;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack itemStack = player.m_21120_(hand);
                if (!DestroyItems.SEISMOMETER.isIn(itemStack)) continue;
                holdingSeismometer = true;
            }
            if (holdingSeismometer) {
                LevelChunk chunk = level.m_46745_(player.m_20097_());
                int bucketsOfOil = chunk.getCapability(ChunkCrudeOil.Provider.CHUNK_CRUDE_OIL).map(crudeOil -> {
                    crudeOil.generate(chunk, (Player)player);
                    return crudeOil.getAmount();
                }).orElse(0) / 1000;
                if (!level.m_5776_()) {
                    player.m_5661_((Component)DestroyLang.translate("tooltip.seismometer.crude_oil", bucketsOfOil).component(), true);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    DestroyMessages.sendToClient(new SeismometerSpikeS2CPacket(), serverPlayer);
                }
                if (bucketsOfOil > 0) {
                    DestroyAdvancements.USE_SEISMOMETER.award(level, (Player)player);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onBabyBirthed(BabyEntitySpawnEvent event) {
        if (!PollutionHelper.pollutionEnabled() || !((Boolean)DestroyAllConfigs.SERVER.pollution.breedingAffected.get()).booleanValue()) {
            return;
        }
        Level level = event.getParentA().m_9236_();
        RandomSource random = event.getParentA().m_217043_();
        if (event.getParentA().m_217043_().m_188503_(LevelPollution.PollutionType.SMOG.max) <= PollutionHelper.getPollution(level, LevelPollution.PollutionType.SMOG)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (Mob parent : List.of(event.getParentA(), event.getParentB())) {
                    for (int i = 0; i < 7; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, parent.m_20208_(1.0), parent.m_20187_() + 0.5, parent.m_20262_(1.0), 1, random.m_188583_() * 0.5, random.m_188583_() * 0.5, random.m_188583_() * 0.5, 0.02);
                    }
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlantGrows(BlockEvent.CropGrowEvent.Pre event) {
        if (!PollutionHelper.pollutionEnabled() || !((Boolean)DestroyAllConfigs.SERVER.pollution.growingAffected.get()).booleanValue()) {
            return;
        }
        LevelPollution.PollutionType[] pollutionTypeArray = event.getLevel();
        if (!(pollutionTypeArray instanceof Level)) {
            return;
        }
        Level level = (Level)pollutionTypeArray;
        for (LevelPollution.PollutionType pollutionType : new LevelPollution.PollutionType[]{LevelPollution.PollutionType.SMOG, LevelPollution.PollutionType.GREENHOUSE, LevelPollution.PollutionType.ACID_RAIN}) {
            if (level.f_46441_.m_188503_(pollutionType.max) > PollutionHelper.getPollution(level, pollutionType)) continue;
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public static void onContaminatedArmorRemoved(LivingEquipmentChangeEvent event) {
        CompoundTag tag = event.getFrom().m_41784_();
        if (tag.m_128425_("ContaminatingFluid", 10)) {
            ChemistryDamageHelper.damage(event.getEntity().m_9236_(), event.getEntity(), FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("ContaminatingFluid")), true);
            ChemistryDamageHelper.decontaminate(event.getFrom());
        }
    }

    @SubscribeEvent
    public static void onTreeGrown(SaplingGrowTreeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.f_46441_.m_188503_(3) == 0) {
            PollutionHelper.changePollution(level, LevelPollution.PollutionType.GREENHOUSE, -1);
        }
        if (level.f_46441_.m_188503_(3) == 0) {
            PollutionHelper.changePollution(level, LevelPollution.PollutionType.SMOG, -1);
        }
        if (level.f_46441_.m_188503_(3) == 0) {
            PollutionHelper.changePollution(level, LevelPollution.PollutionType.ACID_RAIN, -1);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        RedstoneProgrammerItemHandler.tick((LevelAccessor)level);
        for (LevelPollution.PollutionType pollutionType : LevelPollution.PollutionType.values()) {
            if (level.f_46441_.m_188503_(100) != 0) continue;
            PollutionHelper.changePollution(event.level, pollutionType, -1);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void addPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFileInfo modFileInfo = ModList.get().getModFileById("destroy");
                if (modFileInfo == null) {
                    Destroy.LOGGER.error("Could not find Destroy mod file info; built-in resource packs will be missing!");
                    return;
                }
                IModFile modFile = modFileInfo.getFile();
                event.addRepositorySource(consumer -> {
                    Pack pack = Pack.m_245429_((String)Create.asResource((String)"destroy_create_patches").toString(), (Component)Components.literal((String)"Destroy Patches For Create"), (boolean)true, id -> new ModFilePackResources(id, modFile, "resourcepacks/destroy_create_patches"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    if (pack != null) {
                        consumer.accept(pack);
                    }
                });
            }
        }
    }
}

