/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid;

import com.petrolpark.destroy.chemistry.ClientMixture;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.VirtualFluid;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class MixtureFluid
extends VirtualFluid {
    public MixtureFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static Mixture airMixture(float temperature) {
        if (temperature <= 0.0f || Float.isNaN(temperature)) {
            throw new IllegalStateException("Temperature cannot be negative or 0.");
        }
        Mixture air = new Mixture();
        air.addMolecule(DestroyMolecules.NITROGEN, 9151.2f / temperature);
        air.addMolecule(DestroyMolecules.OXYGEN, 2463.57f / temperature);
        air.setTemperature(temperature);
        return air;
    }

    public static FluidStack of(int amount, ReadOnlyMixture mixture) {
        return MixtureFluid.of(amount, mixture, null);
    }

    public static FluidStack of(int amount, ReadOnlyMixture mixture, @Nullable String translationKey) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = new FluidStack((Fluid)DestroyFluids.MIXTURE.getSource(), amount);
        mixture.setTranslationKey(translationKey);
        MixtureFluid.addMixtureToFluidStack(fluidStack, mixture);
        return fluidStack;
    }

    public static FluidStack addMixtureToFluidStack(FluidStack fluidStack, ReadOnlyMixture mixture) {
        if (mixture.isEmpty()) {
            fluidStack.removeChildTag("Mixture");
            return fluidStack;
        }
        fluidStack.getOrCreateTag().m_128365_("Mixture", (Tag)mixture.writeNBT());
        return fluidStack;
    }

    public static int getTintColor(FluidStack stack) {
        if (stack.isEmpty()) {
            return 0xFFFFFF;
        }
        if (!stack.getOrCreateTag().m_128425_("Mixture", 10)) {
            return -1;
        }
        return ReadOnlyMixture.readNBT(ClientMixture::new, stack.getChildTag("Mixture")).getColor();
    }

    public static class MixtureFluidType
    extends AllFluids.TintedFluidType {
        public MixtureFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return MixtureFluid.getTintColor(stack);
        }

        protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return 0;
        }

        public Component getDescription(FluidStack stack) {
            return ReadOnlyMixture.readNBT(ClientMixture::new, stack.getChildTag("Mixture")).getName();
        }
    }
}

