/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.google.gson.JsonObject;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.fluid.ingredient.MixtureFluidIngredient;
import java.text.DecimalFormat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public abstract class ConcentrationRangeFluidIngredient<T extends MixtureFluidIngredient<T>>
extends MixtureFluidIngredient<T> {
    protected static final DecimalFormat df = new DecimalFormat();
    protected float minConcentration;
    protected float maxConcentration;

    @Override
    public void addNBT(CompoundTag fluidTag) {
        fluidTag.m_128350_("MinimumConcentration", this.minConcentration);
        fluidTag.m_128350_("MaximumConcentration", this.maxConcentration);
    }

    protected void readInternal(FriendlyByteBuf buffer) {
        this.minConcentration = buffer.readFloat();
        this.maxConcentration = buffer.readFloat();
    }

    protected void writeInternal(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.minConcentration);
        buffer.writeFloat(this.maxConcentration);
    }

    protected void readInternal(JsonObject json) {
        if (json.has("concentration")) {
            float concentration = GsonHelper.m_13915_((JsonObject)json, (String)"concentration");
            this.minConcentration = Math.max(0.0f, concentration - 0.1f);
            this.maxConcentration = concentration + 0.1f;
        } else if (json.has("min_concentration") && json.has("max_concentration")) {
            this.minConcentration = GsonHelper.m_13915_((JsonObject)json, (String)"min_concentration");
            this.maxConcentration = GsonHelper.m_13915_((JsonObject)json, (String)"max_concentration");
        } else {
            throw new IllegalStateException("Mixture ingredients must define a concentration or range of concentrations");
        }
    }

    protected void writeInternal(JsonObject json) {
        json.addProperty("min_concentration", (Number)Float.valueOf(this.minConcentration));
        json.addProperty("max_concentration", (Number)Float.valueOf(this.maxConcentration));
    }

    public float getTargetConcentration() {
        return (this.minConcentration + this.maxConcentration) / 2.0f;
    }

    public ReadOnlyMixture getMixtureOfRightConcentration(Molecule molecule) {
        float targetConcentration = this.getTargetConcentration();
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        mixture.addMolecule(molecule, targetConcentration);
        mixture.addMolecule(DestroyMolecules.WATER, DestroyMolecules.WATER.getPureConcentration() * (1.0f - targetConcentration / molecule.getPureConcentration()));
        return mixture;
    }

    static {
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
    }
}

