/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.ingredient.ConcentrationRangeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.MoleculeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class IonFluidIngredient
extends MoleculeFluidIngredient {
    public static final Type TYPE = new Type();

    @Override
    public MixtureFluidIngredientSubType<MoleculeFluidIngredient> getType() {
        return TYPE;
    }

    @Override
    protected boolean testMixture(Mixture mixture) {
        return mixture.hasUsableMolecule(this.molecule, this.minConcentration, this.maxConcentration, m -> m.getCharge() != 0 && Math.signum(m.getCharge()) != Math.signum(this.molecule.getCharge()));
    }

    @Override
    public List<ReadOnlyMixture> getExampleMixtures() {
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        float targetConcentration = this.getTargetConcentration();
        mixture.addMolecule(DestroyMolecules.WATER, DestroyMolecules.WATER.getPureConcentration());
        mixture.addMolecule(this.molecule, targetConcentration);
        mixture.addMolecule(this.molecule.getCharge() > 0 ? DestroyMolecules.CHLORIDE : DestroyMolecules.SODIUM_ION, targetConcentration * (float)Mth.m_14040_((int)this.molecule.getCharge()));
        return List.of(mixture);
    }

    protected static class Type
    extends MoleculeFluidIngredient.Type {
        protected Type() {
        }

        @Override
        public IonFluidIngredient getNew() {
            return new IonFluidIngredient();
        }

        @Override
        public String getMixtureFluidIngredientSubtype() {
            return "mixtureFluidWithIon";
        }

        @Override
        public List<Component> getDescription(CompoundTag fluidTag) {
            String moleculeID = fluidTag.m_128461_("MoleculeRequired");
            float minConc = fluidTag.m_128457_("MinimumConcentration");
            float maxConc = fluidTag.m_128457_("MaximumConcentration");
            Molecule molecule = Molecule.getMolecule(moleculeID);
            MutableComponent moleculeName = molecule == null ? DestroyLang.translate("tooltip.unknown_molecule", new Object[0]).component() : molecule.getName((Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get());
            boolean anion = molecule != null && molecule.getCharge() < 0;
            return TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.mixture_ingredient." + (anion ? "anion" : "cation"), moleculeName, ConcentrationRangeFluidIngredient.df.format(minConc), ConcentrationRangeFluidIngredient.df.format(maxConc)).string(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
        }
    }
}

