/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.fluid.ingredient.IonFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.MoleculeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.MoleculeTagFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.RefrigerantDummyFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.SaltFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;

public abstract class MixtureFluidIngredient<T extends MixtureFluidIngredient<T>>
extends FluidIngredient {
    public static Map<String, MixtureFluidIngredientSubType<?>> MIXTURE_FLUID_INGREDIENT_SUBTYPES = new HashMap();

    public static void registerMixtureFluidIngredientSubType(MixtureFluidIngredientSubType<?> ingredientType) {
        MIXTURE_FLUID_INGREDIENT_SUBTYPES.put(ingredientType.getMixtureFluidIngredientSubtype(), ingredientType);
    }

    protected boolean testInternal(FluidStack fluidStack) {
        if (fluidStack.getFluid().getFluidType() != DestroyFluids.MIXTURE.getType()) {
            return false;
        }
        CompoundTag mixtureTag = fluidStack.getChildTag("Mixture");
        if (mixtureTag.m_128456_()) {
            return false;
        }
        return this.testMixture(Mixture.readNBT(mixtureTag));
    }

    protected final List<FluidStack> determineMatchingFluidStacks() {
        return this.getExampleMixtures().stream().map(mixture -> {
            FluidStack stack = MixtureFluid.of(this.amountRequired, mixture);
            stack.getOrCreateTag().m_128359_("MixtureFluidIngredientSubtype", this.getType().getMixtureFluidIngredientSubtype());
            this.addNBT(stack.getOrCreateTag());
            return stack;
        }).toList();
    }

    public abstract MixtureFluidIngredientSubType<T> getType();

    protected abstract boolean testMixture(Mixture var1);

    public abstract void addNBT(CompoundTag var1);

    public List<ReadOnlyMixture> getExampleMixtures() {
        return List.of();
    }

    static {
        MixtureFluidIngredient.registerMixtureFluidIngredientSubType(MoleculeFluidIngredient.TYPE);
        MixtureFluidIngredient.registerMixtureFluidIngredientSubType(SaltFluidIngredient.TYPE);
        MixtureFluidIngredient.registerMixtureFluidIngredientSubType(MoleculeTagFluidIngredient.TYPE);
        MixtureFluidIngredient.registerMixtureFluidIngredientSubType(RefrigerantDummyFluidIngredient.TYPE);
        MixtureFluidIngredient.registerMixtureFluidIngredientSubType(IonFluidIngredient.TYPE);
    }
}

