/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.google.gson.JsonObject;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.ingredient.ConcentrationRangeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;

public class MoleculeFluidIngredient
extends ConcentrationRangeFluidIngredient<MoleculeFluidIngredient> {
    public static final Type TYPE = new Type();
    protected Molecule molecule;

    @Override
    public MixtureFluidIngredientSubType<MoleculeFluidIngredient> getType() {
        return TYPE;
    }

    @Override
    public void addNBT(CompoundTag fluidTag) {
        super.addNBT(fluidTag);
        fluidTag.m_128359_("MoleculeRequired", this.molecule.getFullID());
    }

    @Override
    protected boolean testMixture(Mixture mixture) {
        return mixture.hasUsableMolecule(this.molecule, this.minConcentration, this.maxConcentration, null);
    }

    @Override
    protected void readInternal(FriendlyByteBuf buffer) {
        super.readInternal(buffer);
        this.molecule = Molecule.getMolecule(buffer.m_130277_());
    }

    @Override
    protected void writeInternal(FriendlyByteBuf buffer) {
        super.writeInternal(buffer);
        buffer.m_130070_(this.molecule.getFullID());
    }

    @Override
    protected void readInternal(JsonObject json) {
        super.readInternal(json);
        this.molecule = Molecule.getMolecule(GsonHelper.m_13906_((JsonObject)json, (String)"molecule"));
    }

    @Override
    protected void writeInternal(JsonObject json) {
        super.writeInternal(json);
        json.addProperty("molecule", this.molecule.getFullID());
    }

    @Override
    public List<ReadOnlyMixture> getExampleMixtures() {
        return List.of(this.getMixtureOfRightConcentration(this.molecule));
    }

    protected static class Type
    extends MixtureFluidIngredientSubType<MoleculeFluidIngredient> {
        protected Type() {
        }

        @Override
        public MoleculeFluidIngredient getNew() {
            return new MoleculeFluidIngredient();
        }

        @Override
        public String getMixtureFluidIngredientSubtype() {
            return "mixtureFluidWithMolecule";
        }

        @Override
        public List<Component> getDescription(CompoundTag fluidTag) {
            String moleculeID = fluidTag.m_128461_("MoleculeRequired");
            float minConc = fluidTag.m_128457_("MinimumConcentration");
            float maxConc = fluidTag.m_128457_("MaximumConcentration");
            Molecule molecule = Molecule.getMolecule(moleculeID);
            MutableComponent moleculeName = molecule == null ? DestroyLang.translate("tooltip.unknown_molecule", new Object[0]).component() : molecule.getName((Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get());
            return TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.mixture_ingredient.molecule", moleculeName, ConcentrationRangeFluidIngredient.df.format(minConc), ConcentrationRangeFluidIngredient.df.format(maxConc)).string(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
        }

        @Override
        public Collection<Molecule> getContainedMolecules(CompoundTag fluidTag) {
            String moleculeID = fluidTag.m_128461_("MoleculeRequired");
            Molecule molecule = Molecule.getMolecule(moleculeID);
            if (molecule == null) {
                return List.of();
            }
            return List.of(molecule);
        }
    }
}

