/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.google.gson.JsonObject;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.MoleculeTag;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.fluid.ingredient.ConcentrationRangeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public class MoleculeTagFluidIngredient
extends ConcentrationRangeFluidIngredient<MoleculeTagFluidIngredient> {
    public static final Type TYPE = new Type();
    protected MoleculeTag tag;

    public MoleculeTagFluidIngredient(MoleculeTag tag, float minConc, float maxConc) {
        this.tag = tag;
        this.minConcentration = minConc;
        this.maxConcentration = maxConc;
    }

    public MoleculeTagFluidIngredient() {
    }

    @Override
    public MixtureFluidIngredientSubType<MoleculeTagFluidIngredient> getType() {
        return TYPE;
    }

    @Override
    protected boolean testMixture(Mixture mixture) {
        return mixture.hasUsableMolecules(m -> m.hasTag(this.tag), this.minConcentration, this.maxConcentration, m -> false);
    }

    @Override
    public void addNBT(CompoundTag fluidTag) {
        super.addNBT(fluidTag);
        fluidTag.m_128359_("MoleculeTag", this.tag.getId());
    }

    @Override
    protected void readInternal(FriendlyByteBuf buffer) {
        super.readInternal(buffer);
        this.tag = MoleculeTag.MOLECULE_TAGS.get(buffer.m_130277_());
    }

    @Override
    protected void writeInternal(FriendlyByteBuf buffer) {
        super.writeInternal(buffer);
        buffer.m_130070_(this.tag.getId());
    }

    @Override
    protected void readInternal(JsonObject json) {
        super.readInternal(json);
        IllegalStateException e = new IllegalStateException("Molecule Tag fluid ingredients must declare a valid tag");
        if (!json.has("tag")) {
            throw e;
        }
        String tagId = GsonHelper.m_13906_((JsonObject)json, (String)"tag");
        this.tag = MoleculeTag.MOLECULE_TAGS.get(tagId);
        if (this.tag == null) {
            throw e;
        }
    }

    @Override
    protected void writeInternal(JsonObject json) {
        super.writeInternal(json);
        json.addProperty("tag", this.tag.getId());
    }

    @Override
    public List<ReadOnlyMixture> getExampleMixtures() {
        return MoleculeTag.MOLECULES_WITH_TAGS.get(this.tag).stream().map(this::getMixtureOfRightConcentration).toList();
    }

    protected static class Type
    extends MixtureFluidIngredientSubType<MoleculeTagFluidIngredient> {
        protected Type() {
        }

        @Override
        public MoleculeTagFluidIngredient getNew() {
            return new MoleculeTagFluidIngredient();
        }

        @Override
        public String getMixtureFluidIngredientSubtype() {
            return "mixtureFluidWithTaggedMolecules";
        }

        @Override
        public List<Component> getDescription(CompoundTag fluidTag) {
            String tagId = fluidTag.m_128461_("MoleculeTag");
            if (tagId == null || tagId.isEmpty()) {
                return List.of();
            }
            MoleculeTag tag = MoleculeTag.MOLECULE_TAGS.get(tagId);
            if (tag == null) {
                return List.of();
            }
            float minConc = fluidTag.m_128457_("MinimumConcentration");
            float maxConc = fluidTag.m_128457_("MaximumConcentration");
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.mixture_ingredient.molecule_tag_1", new Object[0]).string(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE));
            tooltip.add(tag.getFormattedName());
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.mixture_ingredient.molecule_tag_2", ConcentrationRangeFluidIngredient.df.format(minConc), ConcentrationRangeFluidIngredient.df.format(maxConc)).string(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE));
            return tooltip;
        }

        @Override
        public Collection<Molecule> getContainedMolecules(CompoundTag fluidTag) {
            return MoleculeTag.MOLECULES_WITH_TAGS.get(MoleculeTag.MOLECULE_TAGS.get(fluidTag.m_128461_("MoleculeTag")));
        }
    }
}

