/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.fluid.ingredient;

import com.google.gson.JsonObject;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.chemistry.naming.NamedSalt;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.ingredient.ConcentrationRangeFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;

public class SaltFluidIngredient
extends ConcentrationRangeFluidIngredient<SaltFluidIngredient> {
    public static final Type TYPE = new Type();
    protected Molecule cation;
    protected Molecule anion;

    @Override
    public MixtureFluidIngredientSubType<SaltFluidIngredient> getType() {
        return TYPE;
    }

    @Override
    public void addNBT(CompoundTag fluidTag) {
        super.addNBT(fluidTag);
        fluidTag.m_128359_("RequiredCation", this.cation.getFullID());
        fluidTag.m_128359_("RequiredAnion", this.anion.getFullID());
    }

    @Override
    protected boolean testMixture(Mixture mixture) {
        return mixture.hasUsableMolecule(this.cation, this.minConcentration * (float)this.cation.getCharge(), this.maxConcentration * (float)this.cation.getCharge(), molecule -> molecule == this.anion) && mixture.hasUsableMolecule(this.anion, this.minConcentration * (float)(-this.anion.getCharge()), this.maxConcentration * (float)(-this.anion.getCharge()), molecule -> molecule == this.cation);
    }

    @Override
    protected void readInternal(FriendlyByteBuf buffer) {
        super.readInternal(buffer);
        this.cation = Molecule.getMolecule(buffer.m_130277_());
        this.anion = Molecule.getMolecule(buffer.m_130277_());
    }

    @Override
    protected void writeInternal(FriendlyByteBuf buffer) {
        super.writeInternal(buffer);
        buffer.m_130070_(this.cation.getFullID());
        buffer.m_130070_(this.anion.getFullID());
    }

    @Override
    protected void readInternal(JsonObject json) {
        super.readInternal(json);
        if (!json.has("cation") || !json.has("anion")) {
            throw new IllegalStateException("Salt Mixture Ingredients must declare a cation and anion");
        }
        this.cation = Molecule.getMolecule(GsonHelper.m_13906_((JsonObject)json, (String)"cation"));
        if (this.cation.getCharge() <= 0) {
            throw new IllegalStateException("Cations must be positively charged.");
        }
        this.anion = Molecule.getMolecule(GsonHelper.m_13906_((JsonObject)json, (String)"anion"));
        if (this.anion.getCharge() >= 0) {
            throw new IllegalStateException("Anions must be negatively charged.");
        }
    }

    @Override
    protected void writeInternal(JsonObject json) {
        super.writeInternal(json);
        json.addProperty("cation", this.cation.getFullID());
        json.addProperty("anion", this.anion.getFullID());
    }

    @Override
    public List<ReadOnlyMixture> getExampleMixtures() {
        ReadOnlyMixture mixture = new ReadOnlyMixture();
        float targetConcentration = this.getTargetConcentration();
        mixture.addMolecule(DestroyMolecules.WATER, DestroyMolecules.WATER.getPureConcentration());
        mixture.addMolecule(this.cation, targetConcentration);
        mixture.addMolecule(this.anion, targetConcentration);
        return List.of(mixture);
    }

    protected static class Type
    extends MixtureFluidIngredientSubType<SaltFluidIngredient> {
        protected Type() {
        }

        @Override
        public SaltFluidIngredient getNew() {
            return new SaltFluidIngredient();
        }

        @Override
        public String getMixtureFluidIngredientSubtype() {
            return "mixtureFluidWithSalt";
        }

        @Override
        public List<Component> getDescription(CompoundTag fluidTag) {
            String cationID = fluidTag.m_128461_("RequiredCation");
            String anionID = fluidTag.m_128461_("RequiredAnion");
            float minConc = fluidTag.m_128457_("MinimumConcentration");
            float maxConc = fluidTag.m_128457_("MaximumConcentration");
            boolean iupac = (Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get();
            Molecule cation = Molecule.getMolecule(cationID);
            Molecule anion = Molecule.getMolecule(anionID);
            MutableComponent compoundName = cation == null || anion == null ? DestroyLang.translate("tooltip.unknown_molecule", new Object[0]).component() : new NamedSalt(cation, anion).getName(iupac);
            return TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.mixture_ingredient.molecule", compoundName, ConcentrationRangeFluidIngredient.df.format(minConc), ConcentrationRangeFluidIngredient.df.format(maxConc)).string(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
        }

        @Override
        public Collection<Molecule> getContainedMolecules(CompoundTag fluidTag) {
            String cationID = fluidTag.m_128461_("RequiredCation");
            String anionID = fluidTag.m_128461_("RequiredAnion");
            Molecule cation = Molecule.getMolecule(cationID);
            Molecule anion = Molecule.getMolecule(anionID);
            ArrayList<Molecule> molecules = new ArrayList<Molecule>(2);
            if (cation != null) {
                molecules.add(cation);
            }
            if (anion != null) {
                molecules.add(anion);
            }
            return molecules;
        }
    }
}

