/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.google.common.collect.ImmutableList;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.SandCastleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BucketAndSpadeItem
extends Item {
    private static final ImmutableList<Block> validBlocks = ImmutableList.of((Object)Blocks.f_49992_, (Object)Blocks.f_49993_, (Object)Blocks.f_50135_);

    public BucketAndSpadeItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new BucketAndSpadeDispenseBehaviour());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_() == null) {
            return InteractionResult.PASS;
        }
        BlockState blockUnderneath = context.m_43725_().m_8055_(context.m_8083_());
        BlockPos posAbove = context.m_8083_().m_7494_();
        if (BucketAndSpadeItem.buildSandcastle(null, posAbove, blockUnderneath, context.m_43722_())) {
            context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), p -> p.m_21190_(context.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public static boolean buildSandcastle(Level level, BlockPos posAbove, BlockState stateUnderneath, ItemStack stack) {
        if (level == null) {
            return false;
        }
        if (BucketAndSpadeItem.canSandCastleBeBuiltOn(stateUnderneath, level.m_8055_(posAbove)) && level.m_46597_(posAbove, BucketAndSpadeItem.getSandCastleForMaterial(stateUnderneath))) {
            level.m_5594_(null, posAbove, SoundEvents.f_12331_, SoundSource.BLOCKS, 0.5f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean canSandCastleBeBuiltOn(BlockState state, BlockState stateAbove) {
        return validBlocks.stream().anyMatch(block -> state.m_60713_(block)) && stateAbove.m_60795_();
    }

    public static BlockState getSandCastleForMaterial(BlockState stateUnderneath) {
        SandCastleBlock.Material material = SandCastleBlock.Material.SAND;
        if (stateUnderneath.m_60713_(Blocks.f_49993_)) {
            material = SandCastleBlock.Material.RED_SAND;
        } else if (stateUnderneath.m_60713_(Blocks.f_50135_)) {
            material = SandCastleBlock.Material.SOUL_SAND;
        }
        return (BlockState)DestroyBlocks.SAND_CASTLE.getDefaultState().m_61124_(SandCastleBlock.MATERIAL, (Comparable)((Object)material));
    }

    public static class BucketAndSpadeDispenseBehaviour
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos posAbove = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            if (BucketAndSpadeItem.buildSandcastle((Level)source.m_7727_(), posAbove, source.m_7727_().m_8055_(posAbove.m_121945_(Direction.DOWN)), stack)) {
                if (stack.m_220157_(1, source.m_7727_().m_213780_(), null)) {
                    stack.m_41774_(1);
                }
                this.m_123573_(true);
            } else {
                this.m_123573_(false);
            }
            return stack;
        }
    }
}

