/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.block.CoaxialGearBlock;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CoaxialGearBlockItem
extends CogwheelBlockItem {
    public CoaxialGearBlockItem(CoaxialGearBlock block, Item.Properties properties) {
        super((CogWheelBlock)block, properties);
        PlacementHelpers.register((IPlacementHelper)new GearOnShaftPlacementHelper());
        PlacementHelpers.register((IPlacementHelper)new ShaftOnGearPlacementHelper());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (ShaftBlock.isShaft((BlockState)state)) {
            if (CoaxialGearBlock.tryMakeLongShaft(state, level, pos, Direction.m_175357_((Entity)player, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))))) {
                if (!level.m_5776_() && !player.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            player.m_5661_((Component)DestroyLang.translate("tooltip.coaxial_gear.shaft_too_short", new Object[0]).style(ChatFormatting.RED).component(), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private static final class GearOnShaftPlacementHelper
    implements IPlacementHelper {
        private GearOnShaftPlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> {
                BlockItem blockItem;
                Item patt2728$temp = stack.m_41720_();
                return patt2728$temp instanceof BlockItem && CoaxialGearBlock.isCoaxialGear((blockItem = (BlockItem)patt2728$temp).m_40614_());
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return ShaftBlock::isShaft;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))));
        }
    }

    private static final class ShaftOnGearPlacementHelper
    implements IPlacementHelper {
        private ShaftOnGearPlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return CoaxialGearBlock::isCoaxialGear;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))));
        }
    }
}

