/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.util.CropMutation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HyperaccumulatingFertilizerItem
extends BoneMealItem {
    public HyperaccumulatingFertilizerItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new HyperaccumulatingFertilizerDispenserBehaviour());
    }

    private static boolean grow(Level level, BlockPos cropPos) {
        CropMutation mutation;
        BlockState crostate = level.m_8055_(cropPos);
        Block cropBlock = crostate.m_60734_();
        BlockPos potentialOrePos = cropPos.m_6625_(2);
        BlockState potentialOreState = level.m_8055_(potentialOrePos);
        if (cropBlock instanceof BonemealableBlock && crostate.m_204336_(BlockTags.f_13073_) && (mutation = CropMutation.getMutation(crostate, potentialOreState)).isSuccessful()) {
            if (level.m_5776_()) {
                HyperaccumulatingFertilizerItem.m_40638_((LevelAccessor)level, (BlockPos)cropPos, (int)100);
                return true;
            }
            level.m_46597_(cropPos, mutation.getResultantCropSupplier().get());
            if (mutation.isOreSpecific()) {
                level.m_46597_(potentialOrePos, mutation.getResultantBlockUnder(potentialOreState));
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        boolean couldGrow = HyperaccumulatingFertilizerItem.grow(level, context.m_8083_());
        if (couldGrow) {
            Player player = context.m_43723_();
            if (!level.m_5776_() && player != null && !player.m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
            DestroyAdvancements.HYPERACCUMULATE.award(level, player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public static class HyperaccumulatingFertilizerDispenserBehaviour
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            BlockPos blockPos;
            ServerLevel level = blockSource.m_7727_();
            if (HyperaccumulatingFertilizerItem.grow((Level)level, blockPos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)))) {
                stack.m_41774_(1);
                this.m_123573_(true);
            } else if (BoneMealItem.m_40627_((ItemStack)stack, (Level)level, (BlockPos)blockPos) || BoneMealItem.m_40631_((ItemStack)stack, (Level)level, (BlockPos)blockPos, (Direction)null)) {
                this.m_123573_(true);
                if (!level.m_5776_()) {
                    level.m_46796_(1505, blockPos, 0);
                }
            } else {
                this.m_123573_(false);
            }
            return stack;
        }
    }
}

