/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.MoleculeTag;
import com.petrolpark.destroy.client.gui.MoleculeRenderer;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.item.tooltip.DestroyTooltipComponent;
import com.petrolpark.destroy.util.DestroyLang;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MoleculeDisplayItem
extends Item {
    private static final DecimalFormat df = new DecimalFormat();

    public MoleculeDisplayItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack with(Molecule molecule) {
        ItemStack stack = new ItemStack((ItemLike)DestroyItems.MOLECULE_DISPLAY.get(), 1);
        stack.m_41784_().m_128359_("Molecule", molecule.getFullID());
        return stack;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        Molecule molecule = MoleculeDisplayItem.getMolecule(stack);
        if (molecule == null) {
            return Optional.empty();
        }
        return Optional.of(new MoleculeTooltip(molecule));
    }

    private static Molecule getMolecule(ItemStack itemStack) {
        if (!DestroyItems.MOLECULE_DISPLAY.isIn(itemStack)) {
            return null;
        }
        return Molecule.getMolecule(itemStack.m_41784_().m_128461_("Molecule"));
    }

    public static List<Component> getLore(Molecule molecule) {
        ImmutableSet<MoleculeTag> tags;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (molecule == null) {
            return tooltip;
        }
        boolean novel = molecule.isNovel();
        boolean charged = molecule.getCharge() != 0;
        boolean hypothetical = molecule.isHypothetical();
        boolean nerdMode = (Boolean)DestroyAllConfigs.CLIENT.chemistry.nerdMode.get();
        DestroyLang.TemperatureUnit unit = (DestroyLang.TemperatureUnit)((Object)DestroyAllConfigs.CLIENT.chemistry.temperatureUnit.get());
        if (hypothetical) {
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.r_group", new Object[0]).style(ChatFormatting.DARK_GRAY).component());
        }
        if (nerdMode && !novel) {
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.formula", molecule.getSerlializedMolecularFormula(true) + DestroyLang.toSuperscript(molecule.getSerializedCharge(false))).component().m_130940_(ChatFormatting.GRAY));
        }
        if (charged && (!nerdMode || novel)) {
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.charge", molecule.getSerializedCharge(true)).component().m_130940_(ChatFormatting.GRAY));
        }
        if (!hypothetical) {
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.mass", df.format(molecule.getMass())).component().m_130940_(ChatFormatting.GRAY));
        }
        if (!charged && !hypothetical) {
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.boiling_point", unit.of(molecule.getBoilingPoint(), df)).component().m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)DestroyLang.translate("tooltip.molecule.density", df.format(molecule.getDensity())).component().m_130940_(ChatFormatting.GRAY));
            if (nerdMode) {
                tooltip.add((Component)DestroyLang.translate("tooltip.molecule.heat_capacity", df.format(molecule.getMolarHeatCapacity())).component().m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)DestroyLang.translate("tooltip.molecule.latent_heat", df.format(molecule.getLatentHeat() / 1000.0f)).component().m_130940_(ChatFormatting.GRAY));
            }
        }
        if (!(tags = molecule.getTags()).isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)" "));
        }
        for (MoleculeTag tag : tags) {
            tooltip.add(tag.getFormattedName());
        }
        return tooltip;
    }

    static {
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
    }

    public static class MoleculeTooltip
    extends DestroyTooltipComponent<MoleculeTooltip, ClientMoleculeTooltipComponent> {
        private final Molecule molecule;

        public MoleculeTooltip(Molecule molecule) {
            super(ClientMoleculeTooltipComponent::new);
            this.molecule = molecule;
        }

        public Molecule getMolecule() {
            return this.molecule;
        }
    }

    public static class ClientMoleculeTooltipComponent
    implements ClientTooltipComponent {
        private final MoleculeRenderer renderer;
        private int height;
        private int width;

        public ClientMoleculeTooltipComponent(MoleculeTooltip tooltipComponent) {
            this.renderer = tooltipComponent.getMolecule().getRenderer();
            this.height = this.renderer.getHeight() + 15;
            this.width = this.renderer.getWidth() + 15;
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(Font pFont) {
            return this.width;
        }

        public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics graphics) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 250.0f);
            this.renderer.render(mouseX + 10, mouseY + 5, graphics);
            poseStack.m_85849_();
        }
    }
}

