/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.RedstoneProgrammerBlock;
import com.petrolpark.destroy.client.gui.menu.RedstoneProgrammerMenu;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.petrolpark.destroy.util.RedstoneProgrammerItemHandler;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;

public class RedstoneProgrammerBlockItem
extends BlockItem {
    public RedstoneProgrammerBlockItem(RedstoneProgrammerBlock block, Item.Properties properties) {
        super((Block)block, properties);
        properties.m_41487_(1);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        if (player.m_6144_()) {
            return super.onItemUseFirst(stack, context);
        }
        RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, (LivingEntity)player).ifPresent(program -> {
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new ItemStackRedstoneProgramMenuOpener((RedstoneProgram)program), program::write);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(usedHand));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, player).ifPresent(program -> {
                program.load();
                program.tick();
                RedstoneProgrammerBlockItem.setProgram(stack, program);
            });
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack from, ItemStack to, boolean slotChanged) {
        return !(from.m_41720_() instanceof RedstoneProgrammerBlockItem) || !(to.m_41720_() instanceof RedstoneProgrammerBlockItem);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack from, ItemStack to) {
        return !(from.m_41720_() instanceof RedstoneProgrammerBlockItem) || !(to.m_41720_() instanceof RedstoneProgrammerBlockItem);
    }

    public static void setProgram(ItemStack stack, RedstoneProgram program) {
        stack.m_41784_().m_128365_("Program", (Tag)program.write());
    }

    public static ItemStack withProgram(RedstoneProgram program) {
        ItemStack stack = DestroyBlocks.REDSTONE_PROGRAMMER.asStack();
        RedstoneProgrammerBlockItem.setProgram(stack, program);
        return stack;
    }

    public static Optional<RedstoneProgram> getProgram(ItemStack item, LevelAccessor level, LivingEntity player) {
        if (!(item.m_41720_() instanceof RedstoneProgrammerBlockItem) || player == null) {
            return Optional.empty();
        }
        CompoundTag tag = item.m_41784_();
        UUID uuid = null;
        if (tag.m_128441_("UUID")) {
            uuid = tag.m_128342_("UUID");
        } else {
            uuid = UUID.randomUUID();
            tag.m_128362_("UUID", uuid);
        }
        ItemStackRedstoneProgram program = ((Map)RedstoneProgrammerItemHandler.programs.get(level)).computeIfAbsent(uuid, u -> {
            if (!tag.m_128441_("Program")) {
                return new ItemStackRedstoneProgram(player);
            }
            return RedstoneProgram.read(() -> new ItemStackRedstoneProgram(player), item.m_41784_().m_128469_("Program"));
        });
        return Optional.of(program);
    }

    public static class ItemStackRedstoneProgram
    extends RedstoneProgram {
        public int ttl;
        protected final LivingEntity player;

        public ItemStackRedstoneProgram(LivingEntity player) {
            this.player = player;
            this.ttl = 30;
        }

        @Override
        public void tick() {
            this.ttl = 30;
            super.tick();
        }

        @Override
        public boolean hasPower() {
            return false;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.player.m_20097_();
        }

        @Override
        public boolean shouldTransmit() {
            return this.ttl > 0;
        }

        @Override
        public LevelAccessor getWorld() {
            return this.player.m_9236_();
        }
    }

    public record ItemStackRedstoneProgramMenuOpener(RedstoneProgram program) implements MenuProvider
    {
        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return RedstoneProgrammerMenu.create(id, inv, this.program);
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }
    }
}

