/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SprayBottleItem
extends Item {
    public final MobEffectInstance[] effects;

    public SprayBottleItem(Item.Properties properties, MobEffectInstance ... effects) {
        super(properties);
        this.effects = effects;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new SprayBottleDispenserBehaviour());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        this.spawnEffectCloud(context.m_43725_(), context.m_43720_(), player);
        DestroySoundEvents.SPRAY_BOTTLE_SPRAYS.play(context.m_43725_(), player, (Vec3i)context.m_8083_());
        if (player != null && !player.m_7500_()) {
            context.m_43722_().m_41774_(1);
            player.m_150109_().m_150079_(DestroyItems.SPRAY_BOTTLE.asStack());
        }
        return InteractionResult.SUCCESS;
    }

    public void spawnEffectCloud(Level level, Vec3 position, @Nullable Player player) {
        AreaEffectCloud effectCloud = new AreaEffectCloud(level, position.f_82479_, position.f_82480_, position.f_82481_);
        if (player != null) {
            effectCloud.m_19718_((LivingEntity)player);
        }
        effectCloud.m_19722_(new Potion(this.effects));
        for (MobEffectInstance instance : this.effects) {
            effectCloud.m_19716_(instance);
        }
        effectCloud.m_19712_(3.0f);
        effectCloud.m_19732_(-0.5f);
        effectCloud.m_19740_(10);
        effectCloud.m_19738_(-effectCloud.m_19743_() / (float)effectCloud.m_19748_());
        level.m_7967_((Entity)effectCloud);
    }

    public class SprayBottleDispenserBehaviour
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Vec3 effectCloudPosition = Vec3.m_82539_((Vec3i)blockSource.m_7961_().m_121945_(direction));
            SprayBottleItem.this.spawnEffectCloud((Level)blockSource.m_7727_(), effectCloudPosition, null);
            DestroySoundEvents.SPRAY_BOTTLE_SPRAYS.play((Level)blockSource.m_7727_(), null, (Vec3i)blockSource.m_7961_());
            LazyOptional invCap = blockSource.m_8118_().getCapability(ForgeCapabilities.ITEM_HANDLER);
            boolean couldInsertEmptyBottle = invCap.map(inv -> ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)DestroyItems.SPRAY_BOTTLE.asStack(), (boolean)false).m_41619_()).orElse(false);
            if (!couldInsertEmptyBottle) {
                SprayBottleDispenserBehaviour.m_123378_((Level)blockSource.m_7727_(), (ItemStack)DestroyItems.SPRAY_BOTTLE.asStack(), (int)6, (Direction)direction, (Position)DispenserBlock.m_52720_((BlockSource)blockSource));
            }
            this.m_123573_(true);
            stack.m_41774_(1);
            return stack;
        }
    }
}

