/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.block.IBlockWithPreferredSwissArmyKnifeTool;
import com.petrolpark.destroy.entity.IEntityWithPreferredSwissArmyKnifeTool;
import com.petrolpark.destroy.item.renderer.SwissArmyKnifeRenderer;
import com.petrolpark.destroy.network.DestroyMessages;
import com.petrolpark.destroy.network.packet.SwissArmyKnifeToolC2SPacket;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class SwissArmyKnifeItem
extends DiggerItem {
    private static int timeUntilToolPutAway = 20;
    @Nullable
    public static Tool selectedTool = null;

    public SwissArmyKnifeItem(float attackDamageModifier, float attackSpeedModifier, Tier tier, Item.Properties properties) {
        super(attackDamageModifier, attackSpeedModifier, tier, BlockTags.f_144282_, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Map<Tool, LerpedFloat> chasers = SwissArmyKnifeItem.getChasers(stack);
        chasers.values().forEach(LerpedFloat::tickChaser);
        SwissArmyKnifeItem.putChasers(stack, chasers);
        if (level.m_5776_() && SwissArmyKnifeItem.getTool(stack) != selectedTool) {
            DestroyMessages.sendToServer(new SwissArmyKnifeToolC2SPacket(selectedTool));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Tool tool = SwissArmyKnifeItem.getTool(context.m_43722_());
        if (tool != null) {
            return tool.exampleTool.get().m_41720_().m_6225_(context);
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (SwissArmyKnifeItem.getTool(stack) == Tool.SHEARS) {
            return Items.f_42574_.m_6880_(stack, playerIn, entity, hand);
        }
        return super.m_6880_(stack, playerIn, entity, hand);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.f_40980_;
    }

    public boolean m_8096_(BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        Tool tool = SwissArmyKnifeItem.getTool(stack);
        return tool != null && tool.actions.contains(toolAction);
    }

    public boolean shouldCauseReequipAnimation(ItemStack from, ItemStack to, boolean slotChanged) {
        return !(from.m_41720_() instanceof SwissArmyKnifeItem) || !(to.m_41720_() instanceof SwissArmyKnifeItem);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() instanceof SwissArmyKnifeItem && newStack.m_41720_() instanceof SwissArmyKnifeItem;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !(oldStack.m_41720_() instanceof SwissArmyKnifeItem) || !(newStack.m_41720_() instanceof SwissArmyKnifeItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new SwissArmyKnifeRenderer()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientPlayerTick() {
        Tool newTool;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        boolean switchTool = false;
        if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SwissArmyKnifeItem) && !(player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof SwissArmyKnifeItem)) {
            newTool = null;
            switchTool = true;
        } else {
            newTool = SwissArmyKnifeItem.getTool((Level)minecraft.f_91073_, minecraft.f_91077_, player.m_6047_());
            if (newTool == null && timeUntilToolPutAway > 0) {
                if (--timeUntilToolPutAway == 0) {
                    switchTool = true;
                }
            } else {
                timeUntilToolPutAway = 20;
            }
        }
        if (switchTool |= newTool != null && newTool != selectedTool) {
            DestroyMessages.sendToServer(new SwissArmyKnifeToolC2SPacket(newTool));
            selectedTool = newTool;
        }
    }

    @Nullable
    public static Tool getTool(Level level, HitResult ray, boolean shiftDown) {
        Tool tool = null;
        if (ray instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)ray;
            BlockState state = level.m_8055_(bhr.m_82425_());
            Block block = state.m_60734_();
            if (block instanceof IBlockWithPreferredSwissArmyKnifeTool) {
                IBlockWithPreferredSwissArmyKnifeTool specialBlock = (IBlockWithPreferredSwissArmyKnifeTool)block;
                return specialBlock.getToolForSwissArmyKnife(level, bhr.m_82425_(), state, false);
            }
            if (state.m_204336_(BlockTags.f_144280_)) {
                tool = Tool.AXE;
            }
            if (state.m_204336_(BlockTags.f_144283_)) {
                tool = Tool.SHOVEL;
            }
            if (state.m_204336_(BlockTags.f_144281_)) {
                tool = Tool.HOE;
            }
            if (state.m_204336_(BlockTags.f_144282_)) {
                tool = Tool.PICKAXE;
            }
            if (state instanceof IForgeShearable) {
                tool = Tool.SHEARS;
            }
            if (state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13089_)) {
                tool = Tool.SHEARS;
            }
            if (shiftDown || tool == null) {
                if (state.m_60734_() instanceof PumpkinBlock) {
                    tool = Tool.SHEARS;
                }
                if (AxeItem.getAxeStrippingState((BlockState)state) != null) {
                    tool = Tool.AXE;
                }
                if (ShovelItem.f_43110_.containsKey(state.m_60734_())) {
                    tool = Tool.SHOVEL;
                }
                if (HoeItem.f_41332_.containsKey(state.m_60734_())) {
                    tool = Tool.HOE;
                }
            }
        } else if (ray instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)ray;
            Entity entity = ehr.m_82443_();
            if (entity instanceof IEntityWithPreferredSwissArmyKnifeTool) {
                IEntityWithPreferredSwissArmyKnifeTool specialEntity = (IEntityWithPreferredSwissArmyKnifeTool)entity;
                return specialEntity.getToolForSwissArmyKnife(shiftDown);
            }
            if (entity instanceof LivingEntity) {
                tool = Tool.AXE;
            }
            if (entity instanceof IForgeShearable) {
                tool = shiftDown ? Tool.AXE : Tool.SHEARS;
            }
        }
        return tool;
    }

    @Nullable
    public static Tool getTool(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("ActiveTool")) {
            return null;
        }
        return Tool.values()[tag.m_128451_("ActiveTool")];
    }

    public static void putTool(ItemStack stack, @Nullable Tool tool) {
        stack.m_41749_("ActiveTool");
        if (tool != null) {
            stack.m_41784_().m_128405_("ActiveTool", tool.ordinal());
        }
        Map<Tool, LerpedFloat> chasers = SwissArmyKnifeItem.getChasers(stack);
        chasers.entrySet().forEach(entry -> ((LerpedFloat)entry.getValue()).chase(entry.getKey() == tool ? 1.0 : 0.0, 0.4, LerpedFloat.Chaser.EXP));
        SwissArmyKnifeItem.putChasers(stack, chasers);
    }

    public static Map<Tool, LerpedFloat> getChasers(ItemStack stack) {
        EnumMap<Tool, LerpedFloat> map = new EnumMap<Tool, LerpedFloat>(Tool.class);
        int ordinal = 0;
        if (!stack.m_41784_().m_128425_("ToolAnimations", 9)) {
            return Tool.ALL_RETRACTED;
        }
        for (Tag t : stack.m_41784_().m_128437_("ToolAnimations", 10)) {
            CompoundTag tag = (CompoundTag)t;
            LerpedFloat toolAngle = LerpedFloat.angular().chase((double)tag.m_128457_("Target"), 0.4, LerpedFloat.Chaser.EXP);
            toolAngle.setValue((double)tag.m_128457_("Value"));
            map.put(Tool.values()[ordinal], toolAngle);
            ++ordinal;
        }
        return map;
    }

    public static void putChasers(ItemStack stack, Map<Tool, LerpedFloat> chasers) {
        ListTag list = new ListTag();
        for (Tool tool : Tool.values()) {
            CompoundTag tag = new CompoundTag();
            LerpedFloat toolAngle = chasers.get((Object)tool);
            if (toolAngle == null) {
                toolAngle = LerpedFloat.angular().chase(0.0, 0.4, LerpedFloat.Chaser.EXP);
            }
            tag.m_128350_("Target", toolAngle.getChaseTarget());
            tag.m_128350_("Value", toolAngle.getValue());
            list.add((Object)tag);
        }
        stack.m_41784_().m_128365_("ToolAnimations", (Tag)list);
    }

    public static enum Tool {
        PICKAXE(ToolActions.DEFAULT_PICKAXE_ACTIONS, () -> new ItemStack((ItemLike)Items.f_42385_)),
        AXE(ToolActions.DEFAULT_AXE_ACTIONS, () -> new ItemStack((ItemLike)Items.f_42386_)),
        SHOVEL(ToolActions.DEFAULT_SHOVEL_ACTIONS, () -> new ItemStack((ItemLike)Items.f_42384_)),
        HOE(ToolActions.DEFAULT_HOE_ACTIONS, () -> new ItemStack((ItemLike)Items.f_42387_)),
        SHEARS(ToolActions.DEFAULT_SHEARS_ACTIONS, () -> new ItemStack((ItemLike)Items.f_42385_));

        public static Map<Tool, LerpedFloat> ALL_RETRACTED;
        public final Set<ToolAction> actions;
        public final Supplier<ItemStack> exampleTool;

        private Tool(Set<ToolAction> toolActions, Supplier<ItemStack> exampleTool) {
            this.actions = toolActions;
            this.exampleTool = exampleTool;
        }

        static {
            ALL_RETRACTED = new EnumMap<Tool, LerpedFloat>(Tool.class);
            for (Tool tool : Tool.values()) {
                ALL_RETRACTED.put(tool, LerpedFloat.angular().chase(0.0, 0.4, LerpedFloat.Chaser.EXP));
            }
        }
    }
}

