/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item;

import com.petrolpark.destroy.block.VatControllerBlock;
import com.petrolpark.destroy.block.VatSideBlock;
import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.chemistry.ClientMixture;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.item.renderer.ILayerTintsWithAlphaItem;
import com.petrolpark.destroy.util.ChemistryDamageHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;

public class TestTubeItem
extends ItemFluidContainer
implements ILayerTintsWithAlphaItem {
    public static final int CAPACITY = 200;
    private static final DecimalFormat df = new DecimalFormat();

    public TestTubeItem(Item.Properties properties) {
        super(properties, 200);
    }

    public static ItemStack of(FluidStack fluidStack) {
        ItemStack stack = DestroyItems.TEST_TUBE.asStack(1);
        TestTubeItem.setContents(stack, fluidStack);
        return stack;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        Optional<FluidStack> contentsOptional = TestTubeItem.getContents(stack);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (contentsOptional.isPresent()) {
                ChemistryDamageHelper.damage(level, livingEntity, contentsOptional.get(), false);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        VatControllerBlockEntity vatController = null;
        if (state.m_60734_() instanceof VatControllerBlock) {
            vatController = level.m_141902_(pos, (BlockEntityType)DestroyBlockEntityTypes.VAT_CONTROLLER.get()).orElse(null);
        } else if (state.m_60734_() instanceof VatSideBlock) {
            vatController = level.m_141902_(pos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get()).map(VatSideBlockEntity::getController).orElse(null);
        }
        if (vatController != null) {
            if (TestTubeItem.isEmpty(context.m_43722_())) {
                for (boolean simulate : Iterate.trueAndFalse) {
                    FluidStack drained = vatController.getLiquidTank().drain(200, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    if (drained.isEmpty()) {
                        return InteractionResult.FAIL;
                    }
                    if (simulate) continue;
                    vatController.updateCachedMixture();
                    vatController.updateGasVolume();
                    player.m_21008_(context.m_43724_(), TestTubeItem.of(drained));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            FluidStack fs = TestTubeItem.getContents(context.m_43722_()).orElse(FluidStack.EMPTY).copy();
            if (fs.isEmpty()) {
                return InteractionResult.FAIL;
            }
            for (boolean simulate : Iterate.trueAndFalse) {
                int filled = vatController.addFluid(fs, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                if (filled == 0) {
                    return InteractionResult.FAIL;
                }
                if (simulate || player.m_7500_()) continue;
                fs.setAmount(fs.getAmount() - filled);
                player.m_21008_(context.m_43724_(), TestTubeItem.of(fs));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack itemStack) {
        if (TestTubeItem.isEmpty(itemStack)) {
            return Component.m_237115_((String)"item.destroy.test_tube.empty");
        }
        return Component.m_237110_((String)"item.destroy.test_tube.filled", (Object[])new Object[]{TestTubeItem.getContents(itemStack).get().getDisplayName()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        if (!DestroyItems.TEST_TUBE.isIn(stack)) {
            return;
        }
        TestTubeItem.getContents(stack).ifPresent(fluidStack -> {
            if (fluidStack.isEmpty()) {
                return;
            }
            String temperature = "";
            tooltip.add((Component)Component.m_237113_((String)""));
            CompoundTag mixtureTag = fluidStack.getOrCreateTag().m_128469_("Mixture");
            if (!mixtureTag.m_128456_()) {
                ClientMixture mixture = ReadOnlyMixture.readNBT(ClientMixture::new, mixtureTag);
                boolean iupac = (Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get();
                temperature = df.format(mixture.getTemperature());
                tooltip.addAll(mixture.getContentsTooltip(iupac, false, false, fluidStack.getAmount(), df).stream().map(c -> c.m_6881_()).toList());
            }
            tooltip.add(2, (Component)Component.m_237113_((String)(" " + fluidStack.getAmount())).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Lang.translateDirect((String)"generic.unit.millibuckets", (Object[])new Object[0])).m_130946_(" " + temperature + "K"));
        });
    }

    public static boolean isEmpty(ItemStack stack) {
        return TestTubeItem.getContents(stack).map(FluidStack::isEmpty).orElse(true);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return TestTubeItem.getContents(stack).map(MixtureFluid::getTintColor).orElse(-1);
        }
        return -1;
    }

    public static Optional<FluidStack> getContents(ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(tanks -> tanks.drain(200, IFluidHandler.FluidAction.SIMULATE));
    }

    public static void setContents(ItemStack itemStack, FluidStack fluidStack) {
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(tanks -> tanks.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE));
    }

    static {
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
    }
}

