/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item.directional;

import com.petrolpark.destroy.item.directional.IDirectionalOnBelt;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class DirectionalTransportedItemStack
extends TransportedItemStack {
    @Nullable
    protected Rotation rotation;

    public DirectionalTransportedItemStack(ItemStack stack) {
        super(stack);
        Item item = stack.m_41720_();
        if (item instanceof IDirectionalOnBelt) {
            IDirectionalOnBelt item2 = (IDirectionalOnBelt)item;
            v0 = item2.rotationForPlacement(stack);
        } else {
            v0 = this.rotation = null;
        }
        if (this.rotation == null) {
            this.rotation = Rotation.NONE;
        }
        this.refreshAngle();
    }

    public float getTargetSideOffset() {
        return 0.0f;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void rotate(Rotation appliedRotation) {
        this.rotation = appliedRotation.m_55952_(this.rotation);
        this.refreshAngle();
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.refreshAngle();
    }

    public void refreshAngle() {
        if (this.rotation != null) {
            this.angle = this.getTargetAngle();
        }
    }

    public int getTargetAngle() {
        if (this.rotation == null) {
            return 0;
        }
        switch (this.rotation) {
            case NONE: {
                return 180;
            }
            case CLOCKWISE_90: {
                return 90;
            }
            case CLOCKWISE_180: {
                return 0;
            }
            case COUNTERCLOCKWISE_90: {
                return 270;
            }
        }
        return 0;
    }

    public TransportedItemStack getSimilar() {
        return DirectionalTransportedItemStack.copy(this);
    }

    public TransportedItemStack copy() {
        return DirectionalTransportedItemStack.copy(this);
    }

    public static DirectionalTransportedItemStack copy(TransportedItemStack stack) {
        DirectionalTransportedItemStack copy = new DirectionalTransportedItemStack(stack.stack.m_41777_());
        copy.beltPosition = stack.beltPosition;
        copy.insertedAt = stack.insertedAt;
        copy.insertedFrom = stack.insertedFrom;
        copy.prevBeltPosition = stack.prevBeltPosition;
        copy.prevSideOffset = stack.prevSideOffset;
        copy.processedBy = stack.processedBy;
        copy.processingTime = stack.processingTime;
        if (stack instanceof DirectionalTransportedItemStack) {
            DirectionalTransportedItemStack directionalStack = (DirectionalTransportedItemStack)stack;
            if (directionalStack.rotation != null) {
                copy.rotation = directionalStack.rotation;
            }
            copy.refreshAngle();
        }
        return copy;
    }

    public static DirectionalTransportedItemStack copyFully(TransportedItemStack stack) {
        DirectionalTransportedItemStack copy = DirectionalTransportedItemStack.copy(stack);
        copy.locked = stack.locked;
        copy.lockedExternally = stack.lockedExternally;
        return copy;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.rotation != null) {
            nbt.m_128405_("Rotation", this.rotation.ordinal());
        }
        return nbt;
    }
}

