/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.item.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.item.DestroyItems;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SeismometerItemRenderer
extends CustomRenderedItemModelRenderer {
    protected static final PartialModel UNANIMATED = new PartialModel(Destroy.asResource("item/seismometer/item"));
    protected static final PartialModel BASE = new PartialModel(Destroy.asResource("item/seismometer/base"));
    protected static final PartialModel NEEDLE = new PartialModel(Destroy.asResource("item/seismometer/needle"));
    protected static final PartialModel PAGE_BLANK = new PartialModel(Destroy.asResource("item/seismometer/page_blank"));
    protected static final PartialModel PAGE_LEVEL = new PartialModel(Destroy.asResource("item/seismometer/page_level"));
    protected static final PartialModel PAGE_SPIKE = new PartialModel(Destroy.asResource("item/seismometer/page_spike"));
    private Boolean spike;
    private static int spikeNextPage;
    private static LerpedFloat angle;

    public static void tick() {
        angle.tickChaser();
        if (spikeNextPage > 0) {
            --spikeNextPage;
        }
    }

    public static void spike() {
        spikeNextPage = 32;
    }

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        int ticksThroughAnimation = AnimationTickHolder.getTicks((boolean)true) % 32;
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean rightHanded = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        ItemDisplayContext mainHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        ItemDisplayContext offHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        boolean animate = false;
        int handModifier = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -1 : 1;
        boolean noControllerInMain = !DestroyItems.SEISMOMETER.isIn(player.m_21205_());
        ms.m_85836_();
        if (transformType == mainHand || transformType == offHand && noControllerInMain) {
            msr.translate(0.0, 0.25, 0.25 * (double)handModifier);
            msr.rotateY((double)(-30 * handModifier));
            msr.rotateZ(-30.0);
            animate = true;
        }
        renderer.render(animate ? BASE.get() : model.getOriginalModel(), light);
        if (!animate) {
            ms.m_85849_();
            return;
        }
        if (this.spike == null || ticksThroughAnimation == 0) {
            this.spike = spikeNextPage > 0;
        }
        BakedModel pageModel = this.spike != false ? PAGE_SPIKE.get() : PAGE_LEVEL.get();
        ms.m_85836_();
        renderer.render(pageModel, light);
        ms.m_85849_();
        float angleToChase = 0.0f;
        angleToChase = this.spike.booleanValue() ? (ticksThroughAnimation < 8 ? -30.0f : (ticksThroughAnimation < 16 ? 30.0f : (ticksThroughAnimation < 24 ? 10.0f : -10.0f))) : (ticksThroughAnimation % 16 < 8 ? 10.0f : -10.0f);
        angle.updateChaseTarget(angleToChase);
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, -0.3125f);
        ms.m_85836_();
        msr.rotateY((double)angle.getValue(partialTicks));
        renderer.render(NEEDLE.get(), light);
        ms.m_85849_();
        ms.m_85849_();
    }

    static {
        angle = LerpedFloat.angular().startWithValue(0.0);
        angle.chase(0.0, (double)0.2f, LerpedFloat.Chaser.EXP);
    }
}

