/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.petrolpark.destroy.util.PollutionHelper;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ConnectivityHandler.class})
public class ConnectivityHandlerMixin {
    @Inject(method={"Lcom/simibubi/create/api/connectivity/ConnectivityHandler;splitMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")}, remap=false)
    private static <T extends BlockEntity> void inSplitMulti(T be, CallbackInfo ci) {
        IMultiBlockEntityContainer.Fluid ifluidBE;
        BlockPos startPos = be.m_58899_();
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int width = ((IMultiBlockEntityContainer)be).getWidth();
        BlockPos origin = be.m_58899_();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        FluidStack toDistribute = FluidStack.EMPTY;
        int maxCapacity = 0;
        if (!(be instanceof IMultiBlockEntityContainer.Fluid) || !(ifluidBE = (IMultiBlockEntityContainer.Fluid)be).hasTank()) {
            return;
        }
        toDistribute = ifluidBE.getFluid(0);
        maxCapacity = ifluidBE.getTankSize(0);
        if (width == 1 && height == 1) {
            if (toDistribute.getAmount() > 0) {
                PollutionHelper.pollute(level, startPos, toDistribute);
            }
            return;
        }
        if (!toDistribute.isEmpty() && !be.m_58901_()) {
            toDistribute.shrink(maxCapacity);
            for (int yOffset = 0; yOffset < height; ++yOffset) {
                for (int xOffset = 0; xOffset < width; ++xOffset) {
                    for (int zOffset = 0; zOffset < width; ++zOffset) {
                        BlockPos pos = switch (axis) {
                            case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                            case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                            case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                            default -> origin;
                        };
                        BlockEntity partAt = ConnectivityHandler.partAt((BlockEntityType)be.m_58903_(), (BlockGetter)level, (BlockPos)pos);
                        if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin) || toDistribute.isEmpty() || partAt == be) continue;
                        int split = Math.min(maxCapacity, toDistribute.getAmount());
                        toDistribute.shrink(split);
                    }
                }
            }
            if (toDistribute.getAmount() > 0) {
                PollutionHelper.pollute(level, startPos, toDistribute);
            }
        }
    }
}

