/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.compat.jei.DestroyJEI;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.AllFluids;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.mixer.CompactingRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreateRecipeCategory.class})
public class CreateRecipeCategoryMixin<T extends Recipe<?>> {
    private static final DecimalFormat df = new DecimalFormat();
    private static final Map<String, Class<? extends Recipe<?>>> CATEGORIES_AND_CLASSES;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void inInit(CreateRecipeCategory.Info<T> info, CallbackInfo ci) {
        String recipeTypeId = info.recipeType().getUid().m_135815_();
        if (CATEGORIES_AND_CLASSES.containsKey(recipeTypeId)) {
            DestroyJEI.RECIPE_TYPES.put(info.recipeType(), CATEGORIES_AND_CLASSES.get(recipeTypeId));
        }
    }

    @Overwrite(remap=false)
    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            Fluid fluid = fluidStack.getFluid();
            if (fluid.m_6212_((Fluid)AllFluids.POTION.get())) {
                name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList potionTooltip = new ArrayList();
                PotionFluidHandler.addPotionTooltip((FluidStack)fluidStack, potionTooltip, (float)1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            } else if (DestroyFluids.isMixture(fluid)) {
                name = DestroyLang.translate("mixture.mixture", new Object[0]).component();
                boolean iupac = (Boolean)DestroyAllConfigs.CLIENT.chemistry.iupacNames.get();
                CompoundTag fluidTag = fluidStack.getOrCreateTag();
                List<Object> mixtureTooltip = new ArrayList();
                if (view.getRole() == RecipeIngredientRole.INPUT || view.getRole() == RecipeIngredientRole.CATALYST) {
                    mixtureTooltip = DestroyLang.mixtureIngredientTooltip(fluidTag);
                } else if (view.getRole() == RecipeIngredientRole.OUTPUT) {
                    CompoundTag mixtureTag = fluidTag.m_128469_("Mixture");
                    if (!mixtureTag.m_128456_()) {
                        ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, mixtureTag);
                        name = mixture.getName();
                        mixtureTooltip = mixture.getContentsTooltip(iupac, false, false, mbAmount, df);
                    } else {
                        mixtureTooltip = List.of(DestroyLang.translate("mixture.empty", new Object[0]).component());
                    }
                }
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                tooltip.addAll(1, mixtureTooltip);
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Components.literal((String)String.valueOf(amount)).m_7220_((Component)Lang.translateDirect((String)"generic.unit.millibuckets", (Object[])new Object[0])).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Components.literal((String)" "));
                siblings.add(text);
            }
        };
    }

    static {
        df.setMinimumFractionDigits(3);
        df.setMaximumFractionDigits(3);
        CATEGORIES_AND_CLASSES = new HashMap();
        CATEGORIES_AND_CLASSES.put("mixing", MixingRecipe.class);
        CATEGORIES_AND_CLASSES.put("packing", CompactingRecipe.class);
        CATEGORIES_AND_CLASSES.put("spout_filling", FillingRecipe.class);
        CATEGORIES_AND_CLASSES.put("draining", EmptyingRecipe.class);
        CATEGORIES_AND_CLASSES.put("sequenced_assembly", SequencedAssemblyRecipe.class);
    }
}

