/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.destroy.fluid.ingredient.MixtureFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.mixin.accessor.FluidIngredientAccessor;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={FluidIngredient.class})
public abstract class FluidIngredientMixin {
    private static final String fluidTagMemberName = "fluidTag";
    private static final String fluidMemberName = "fluid";

    @Overwrite(remap=false)
    public static boolean isFluidIngredient(@Nullable JsonElement je) {
        block6: {
            block5: {
                if (je == null || je.isJsonNull()) {
                    return false;
                }
                if (!je.isJsonObject()) {
                    return false;
                }
                JsonObject json = je.getAsJsonObject();
                if (json.has(fluidTagMemberName) || json.has(fluidMemberName)) break block5;
                if (!MixtureFluidIngredient.MIXTURE_FLUID_INGREDIENT_SUBTYPES.keySet().stream().anyMatch(arg_0 -> ((JsonObject)json).has(arg_0))) break block6;
            }
            return true;
        }
        return false;
    }

    @Overwrite(remap=false)
    public static FluidIngredient deserialize(@Nullable JsonElement je) {
        if (je == null) {
            return FluidIngredient.EMPTY;
        }
        if (!FluidIngredientMixin.isFluidIngredient(je)) {
            throw new JsonSyntaxException("Invalid fluid ingredient: " + Objects.toString(je));
        }
        JsonObject json = je.getAsJsonObject();
        Object ingredient = null;
        if (json.has(fluidMemberName)) {
            ingredient = new FluidIngredient.FluidStackIngredient();
        } else if (json.has(fluidTagMemberName)) {
            ingredient = new FluidIngredient.FluidTagIngredient();
        } else {
            for (Map.Entry<String, MixtureFluidIngredientSubType<?>> mixtureFluidIngredientType : MixtureFluidIngredient.MIXTURE_FLUID_INGREDIENT_SUBTYPES.entrySet()) {
                if (!json.has(mixtureFluidIngredientType.getKey())) continue;
                ingredient = mixtureFluidIngredientType.getValue().getNew();
            }
        }
        if (ingredient == null) {
            throw new IllegalStateException("Unknown Fluid Type");
        }
        ((FluidIngredientAccessor)ingredient).invokeReadInternal(json);
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Fluid ingredient has to define an amount");
        }
        ((FluidIngredientAccessor)ingredient).setAmountRequired(GsonHelper.m_13927_((JsonObject)json, (String)"amount"));
        return ingredient;
    }

    @Overwrite(remap=false)
    public void write(FriendlyByteBuf buffer) {
        FluidIngredient $this = (FluidIngredient)this;
        String ingredientType = null;
        if ($this instanceof FluidIngredient.FluidStackIngredient) {
            ingredientType = fluidMemberName;
        } else if ($this instanceof FluidIngredient.FluidTagIngredient) {
            ingredientType = fluidTagMemberName;
        } else if ($this instanceof MixtureFluidIngredient) {
            MixtureFluidIngredient mixtureFluid = (MixtureFluidIngredient)$this;
            ingredientType = mixtureFluid.getType().getMixtureFluidIngredientSubtype();
        }
        if (ingredientType == null) {
            throw new IllegalStateException("Unknown Fluid ingredient subtype");
        }
        buffer.m_130070_(ingredientType);
        buffer.m_130130_(((FluidIngredientAccessor)((Object)this)).getAmountRequired());
        ((FluidIngredientAccessor)((Object)this)).invokeWriteInternal(buffer);
    }

    @Overwrite(remap=false)
    public static FluidIngredient read(FriendlyByteBuf buffer) {
        String ingredientType = buffer.m_130277_();
        Object ingredient = null;
        ingredient = ingredientType.equals(fluidMemberName) ? new FluidIngredient.FluidStackIngredient() : (ingredientType.equals(fluidTagMemberName) ? new FluidIngredient.FluidTagIngredient() : MixtureFluidIngredient.MIXTURE_FLUID_INGREDIENT_SUBTYPES.get(ingredientType).getNew());
        ((FluidIngredientAccessor)ingredient).setAmountRequired(buffer.m_130242_());
        ((FluidIngredientAccessor)ingredient).invokeReadInternal(buffer);
        return ingredient;
    }
}

