/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.jozufozu.flywheel.util.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.petrolpark.destroy.capability.level.pollution.ClientLevelPollutionData;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.client.particle.TintedSplashParticle;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.util.PollutionHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture*(ILnet/minecraft/resources/ResourceLocation;)V", ordinal=0)})
    public void inRenderSnowAndRainDrawRain(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (!LevelRendererMixin.rainColorAffected()) {
            return;
        }
        Color color = this.getRainColor();
        RenderSystem.setShaderColor((float)color.getRedAsFloat(), (float)color.getGreenAsFloat(), (float)color.getBlueAsFloat(), (float)1.0f);
    }

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture*(ILnet/minecraft/resources/ResourceLocation;)V", ordinal=1)})
    public void inRenderSnowAndRainDrawSnow(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="RETURN")})
    public void inRenderSnowAndRainReturn(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Inject(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void inTickRain(Camera pCamera, CallbackInfo ci, float f, RandomSource randomsource, LevelReader levelreader, BlockPos blockpos, BlockPos blockpos1, int i, int j, int k, int l, BlockPos blockpos2, Biome biome, double d0, double d1, BlockState blockstate, FluidState fluidstate, VoxelShape voxelshape, double d2, double d3, double d4, ParticleOptions particleoptions) {
        if (!LevelRendererMixin.rainColorAffected()) {
            return;
        }
        if (particleoptions == ParticleTypes.f_123762_) {
            return;
        }
        Color color = this.getRainColor();
        ClientLevel level = ((LevelRenderer)this).f_109461_.f_91073_;
        if (level != null) {
            level.m_7106_((ParticleOptions)new TintedSplashParticle.Data(), (double)blockpos1.m_123341_() + d0, (double)blockpos1.m_123342_() + d4, (double)blockpos1.m_123343_() + d1, (double)color.getRedAsFloat(), (double)color.getGreenAsFloat(), (double)color.getBlueAsFloat());
        }
    }

    @Redirect(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))
    public void ignoreAddParticle(ClientLevel level, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (particleData == ParticleTypes.f_123762_ || !LevelRendererMixin.rainColorAffected()) {
            level.m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    private Color getRainColor() {
        LevelPollution levelPollution = ClientLevelPollutionData.getLevelPollution();
        return new Color(Color.mixColors((int)-12689736, (int)-16711936, (float)((float)levelPollution.get(LevelPollution.PollutionType.ACID_RAIN) / (float)LevelPollution.PollutionType.ACID_RAIN.max)));
    }

    private static boolean rainColorAffected() {
        return PollutionHelper.pollutionEnabled() && (Boolean)DestroyAllConfigs.SERVER.pollution.rainColorChanges.get() != false;
    }
}

