/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.mixin.accessor.BasinOperatingBlockEntityAccessor;
import com.petrolpark.destroy.recipe.ReactionInBasinRecipe;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MechanicalMixerBlockEntity.class})
public class MechanicalMixerBlockEntityMixin {
    @Inject(method={"getMatchingRecipes()Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void inGetMatchingRecipes(CallbackInfoReturnable<List<Recipe<?>>> ci) {
        ((BasinOperatingBlockEntityAccessor)((Object)this)).invokeGetBasin().ifPresent(basin -> {
            if (!basin.m_58898_()) {
                return;
            }
            IFluidHandler fluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
            IItemHandler itemHandler = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (fluidHandler == null || itemHandler == null) {
                return;
            }
            boolean containsOnlyMixtures = true;
            ArrayList<ItemStack> availableItemStacks = new ArrayList<ItemStack>();
            ArrayList<FluidStack> availableFluidStacks = new ArrayList<FluidStack>();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (DestroyFluids.isMixture(fluidStack)) {
                    availableFluidStacks.add(fluidStack);
                    continue;
                }
                if (fluidStack.isEmpty()) continue;
                containsOnlyMixtures = false;
            }
            if (!containsOnlyMixtures) {
                return;
            }
            if (availableFluidStacks.size() <= 0) {
                return;
            }
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                availableItemStacks.add(itemHandler.getStackInSlot(slot));
            }
            ReactionInBasinRecipe recipe = ReactionInBasinRecipe.create(availableFluidStacks, availableItemStacks, basin);
            if (recipe != null && BasinRecipe.match((BasinBlockEntity)basin, (Recipe)recipe)) {
                ci.setReturnValue(List.of(recipe));
            }
        });
    }
}

