/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.mixin;

import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.compat.jei.DestroyJEI;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.ingredient.MixtureFluidIngredient;
import com.petrolpark.destroy.mixin.accessor.ProcessingRecipeParamsAccessor;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProcessingRecipe.class})
public abstract class ProcessingRecipeMixin {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void inInit(IRecipeTypeInfo typeInfo, ProcessingRecipeBuilder.ProcessingRecipeParams params, CallbackInfo ci) {
        if (!DestroyJEI.MOLECULE_RECIPES_NEED_PROCESSING) {
            return;
        }
        for (FluidIngredient ingredient : ((ProcessingRecipeParamsAccessor)params).getFluidIngredients()) {
            if (!(ingredient instanceof MixtureFluidIngredient)) continue;
            MixtureFluidIngredient mixtureFluidIngredient = (MixtureFluidIngredient)ingredient;
            CompoundTag fluidTag = new CompoundTag();
            mixtureFluidIngredient.addNBT(fluidTag);
            for (Molecule molecule : mixtureFluidIngredient.getType().getContainedMolecules(fluidTag)) {
                DestroyJEI.MOLECULES_INPUT.putIfAbsent(molecule, new ArrayList());
                DestroyJEI.MOLECULES_INPUT.get(molecule).add((Recipe<?>)((ProcessingRecipe)this));
            }
        }
        for (FluidStack fluidResult : ((ProcessingRecipeParamsAccessor)params).getFluidResults()) {
            if (!DestroyFluids.isMixture(fluidResult)) continue;
            ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, fluidResult.getOrCreateTag().m_128469_("Mixture"));
            for (Molecule molecule : mixture.getContents(true)) {
                DestroyJEI.MOLECULES_OUTPUT.putIfAbsent(molecule, new ArrayList());
                DestroyJEI.MOLECULES_OUTPUT.get(molecule).add((Recipe<?>)((ProcessingRecipe)this));
            }
        }
    }
}

