/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.network.packet;

import com.petrolpark.destroy.capability.entity.EntityChemicalPoison;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.network.packet.S2CPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ChemicalPoisonS2CPacket
extends S2CPacket {
    private final Molecule molecule;

    public ChemicalPoisonS2CPacket(Molecule molecule) {
        this.molecule = molecule;
    }

    public ChemicalPoisonS2CPacket(FriendlyByteBuf buffer) {
        String moleculeID = buffer.m_130277_();
        this.molecule = moleculeID == "NO_MOLECULE" ? null : Molecule.getMolecule(moleculeID);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.molecule == null ? "NO_MOLECULE" : this.molecule.getFullID());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null) {
                if (this.molecule == null) {
                    EntityChemicalPoison.removeMolecule((Entity)minecraft.f_91074_);
                } else {
                    EntityChemicalPoison.setMolecule((Entity)minecraft.f_91074_, this.molecule);
                }
            }
        });
        return true;
    }
}

