/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.network.packet;

import com.petrolpark.destroy.effect.DestroyMobEffects;
import com.petrolpark.destroy.network.packet.S2CPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class CryingS2CPacket
extends S2CPacket {
    private final boolean isCrying;
    private final int entityId;

    public CryingS2CPacket(LivingEntity entity, boolean isCrying) {
        this.entityId = entity.m_19879_();
        this.isCrying = isCrying;
    }

    public CryingS2CPacket(FriendlyByteBuf buffer) {
        this.isCrying = buffer.readBoolean();
        this.entityId = buffer.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isCrying);
        buffer.writeInt(this.entityId);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (entity == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isCrying && !livingEntity.m_21023_((MobEffect)DestroyMobEffects.CRYING.get())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)DestroyMobEffects.CRYING.get(), Integer.MAX_VALUE, 0, true, false, false));
            } else {
                livingEntity.m_21195_((MobEffect)DestroyMobEffects.CRYING.get());
            }
        });
        return true;
    }
}

