/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.network.packet;

import com.petrolpark.destroy.client.particle.DestroyParticleTypes;
import com.petrolpark.destroy.client.particle.data.GasParticleData;
import com.petrolpark.destroy.network.packet.S2CPacket;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class EvaporatingFluidS2CPacket
extends S2CPacket {
    private BlockPos blockPos;
    private FluidStack fluidStack;

    public EvaporatingFluidS2CPacket(BlockPos pos, FluidStack stack) {
        this.blockPos = pos;
        this.fluidStack = stack;
    }

    public EvaporatingFluidS2CPacket(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.fluidStack = buffer.readFluidStack();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.writeFluidStack(this.fluidStack);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Vec3 center = VecHelper.getCenterOf((Vec3i)this.blockPos);
            if (level == null || this.fluidStack.isEmpty()) {
                return;
            }
            GasParticleData particleData = new GasParticleData(DestroyParticleTypes.EVAPORATION.get(), this.fluidStack);
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)particleData, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.07, 0.0);
            }
        });
        return true;
    }
}

