/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.network.packet;

import com.petrolpark.destroy.item.SwissArmyKnifeItem;
import com.petrolpark.destroy.network.packet.C2SPacket;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SwissArmyKnifeToolC2SPacket
extends C2SPacket {
    private final boolean hasTool;
    private final SwissArmyKnifeItem.Tool tool;

    public SwissArmyKnifeToolC2SPacket(@Nullable SwissArmyKnifeItem.Tool tool) {
        this.tool = tool;
        this.hasTool = tool != null;
    }

    public SwissArmyKnifeToolC2SPacket(FriendlyByteBuf buffer) {
        this.hasTool = buffer.readBoolean();
        this.tool = this.hasTool ? SwissArmyKnifeItem.Tool.values()[buffer.readInt()] : null;
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hasTool);
        buffer.writeInt(this.hasTool ? this.tool.ordinal() : 0);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.m_21120_(hand);
                if (!(stack.m_41720_() instanceof SwissArmyKnifeItem)) continue;
                SwissArmyKnifeItem.putTool(stack, this.tool);
            }
        });
        return true;
    }
}

