/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.recipe;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.item.DestroyItems;
import com.petrolpark.destroy.util.DestroyTags;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ExtendedDurationFireworkRocketRecipe
extends CustomRecipe {
    public static final RecipeSerializer<ExtendedDurationFireworkRocketRecipe> DURATION_4_FIREWORK_ROCKET = new SimpleCraftingRecipeSerializer((rl, c) -> new ExtendedDurationFireworkRocketRecipe(rl, c, false));
    public static final RecipeSerializer<ExtendedDurationFireworkRocketRecipe> DURATION_5_FIREWORK_ROCKET = new SimpleCraftingRecipeSerializer((rl, c) -> new ExtendedDurationFireworkRocketRecipe(rl, c, true));
    private static final Ingredient CARD_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DestroyItems.CARD_STOCK.get()});
    private static final Ingredient STAR_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42689_});
    private final Ingredient EXPLOSIVE_INGREDIENT;
    private final boolean secondaryExplosive;

    public ExtendedDurationFireworkRocketRecipe(ResourceLocation id, CraftingBookCategory category, boolean secondaryExplosive) {
        super(id, category);
        this.secondaryExplosive = secondaryExplosive;
        this.EXPLOSIVE_INGREDIENT = ExtendedDurationFireworkRocketRecipe.explosiveIngredient(secondaryExplosive);
    }

    public static final Ingredient explosiveIngredient(boolean secondaryExplosive) {
        return Ingredient.m_204132_(secondaryExplosive ? DestroyTags.DestroyItemTags.SECONDARY_EXPLOSIVE.tag : DestroyTags.DestroyItemTags.PRIMARY_EXPLOSIVE.tag);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean hasCardStock = false;
        boolean hasExplosive = false;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (CARD_INGREDIENT.test(stack)) {
                if (hasCardStock) {
                    return false;
                }
                hasCardStock = true;
            } else if (this.EXPLOSIVE_INGREDIENT.test(stack)) {
                if (hasExplosive) {
                    return false;
                }
                hasExplosive = true;
            } else if (!STAR_INGREDIENT.test(stack) && !stack.m_41619_()) {
                return false;
            }
            if (!hasExplosive || !hasCardStock) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_, 10);
        CompoundTag tag = fireworkStack.m_41698_("Fireworks");
        ListTag explosionsTag = new ListTag();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            CompoundTag explosionTag;
            ItemStack stack = inv.m_8020_(slot);
            if (!STAR_INGREDIENT.test(stack) || (explosionTag = stack.m_41737_("Explosion")) == null) continue;
            explosionsTag.add((Object)explosionTag);
        }
        tag.m_128344_("Flight", (byte)(this.secondaryExplosive ? 5 : 4));
        if (!explosionsTag.isEmpty()) {
            tag.m_128365_("Explosions", (Tag)explosionsTag);
        }
        return fireworkStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.secondaryExplosive ? DURATION_5_FIREWORK_ROCKET : DURATION_4_FIREWORK_ROCKET;
    }

    public static List<CraftingRecipe> exampleRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>(2);
        for (boolean secondary : Iterate.trueAndFalse) {
            ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_, 10);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{CARD_INGREDIENT, ExtendedDurationFireworkRocketRecipe.explosiveIngredient(secondary)});
            int duration = secondary ? 5 : 4;
            fireworkStack.m_41698_("Fireworks").m_128344_("Flight", (byte)duration);
            recipes.add((CraftingRecipe)new ShapelessRecipe(Destroy.asResource("duration_" + duration + "_firework_crafting"), "destroy.firework.duration_" + duration, CraftingBookCategory.MISC, fireworkStack, inputs));
        }
        return recipes;
    }
}

