/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.recipe;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.util.BlockExtrusion;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ExtrusionRecipe
extends ProcessingRecipe<RecipeWrapper> {
    private static int counter = 0;
    private BlockExtrusion extrusion;
    public static final List<ExtrusionRecipe> RECIPES = new ArrayList<ExtrusionRecipe>(BlockExtrusion.EXTRUSIONS.size());

    public ExtrusionRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)DestroyRecipeTypes.EXTRUSION, params);
    }

    public static ExtrusionRecipe create(BlockExtrusion extrusion) {
        Block ingredient = (Block)BlockExtrusion.EXTRUSIONS.inverse().get((Object)extrusion);
        ExtrusionRecipe recipe = (ExtrusionRecipe)new ProcessingRecipeBuilder(ExtrusionRecipe::new, Destroy.asResource("extrusion" + counter++)).withItemIngredients(new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ingredient.m_5456_(), 1)})}).withItemOutputs(new ProcessingOutput[]{new ProcessingOutput(new ItemStack((ItemLike)extrusion.getExtruded(ingredient.m_49966_(), Direction.NORTH).m_60734_().m_5456_(), 1), 1.0f)}).build();
        recipe.extrusion = extrusion;
        return recipe;
    }

    public BlockExtrusion getExtrusion() {
        return this.extrusion;
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return false;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    static {
        for (BlockExtrusion extrusion : BlockExtrusion.EXTRUSIONS.values()) {
            RECIPES.add(ExtrusionRecipe.create(extrusion));
        }
    }
}

